/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Configuration;
import de.sormuras.junit.platform.maven.plugin.shadow.XmlReportsWritingListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.logging.Log;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class JUnitPlatformLauncher
implements Callable<TestExecutionSummary> {
    private final Configuration configuration;
    private final Log log;
    private final Build build;
    private final Launcher launcher;
    private final LauncherDiscoveryRequest request;

    JUnitPlatformLauncher(Configuration configuration) {
        this.configuration = configuration;
        this.log = configuration.getLog();
        this.build = configuration.getMavenProject().getBuild();
        this.launcher = LauncherFactory.create();
        this.request = this.buildRequest();
    }

    private LauncherDiscoveryRequest buildRequest() {
        HashSet<Path> roots = new HashSet<Path>();
        roots.add(Paths.get(this.build.getTestOutputDirectory(), new String[0]));
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request();
        builder.selectors(DiscoverySelectors.selectClasspathRoots(roots));
        if (!this.configuration.getTags().isEmpty()) {
            builder.filters(new Filter[]{TagFilter.includeTags(this.configuration.getTags())});
        }
        builder.configurationParameters(this.configuration.getParameters());
        return builder.build();
    }

    @Override
    public TestExecutionSummary call() {
        this.log.info((CharSequence)"Launching JUnit Platform...");
        this.discover();
        return this.execute();
    }

    private void discover() {
        this.log.debug((CharSequence)"Discovering tests...");
        TestPlan testPlan = this.launcher.discover(this.request);
        testPlan.getRoots().forEach(engine -> this.log.info((CharSequence)(" o " + engine.getDisplayName())));
        this.log.info((CharSequence)"");
        if (!testPlan.containsTests()) {
            String message = "Zero tests discovered!";
            this.log.warn((CharSequence)message);
            if (this.configuration.isStrict()) {
                throw new AssertionError((Object)message);
            }
        }
    }

    private TestExecutionSummary execute() {
        this.log.debug((CharSequence)"Executing tests...");
        SummaryGeneratingListener summary = new SummaryGeneratingListener();
        this.launcher.registerTestExecutionListeners(new TestExecutionListener[]{summary});
        String reports = this.configuration.getReports();
        if (!reports.trim().isEmpty()) {
            Path path = Paths.get(reports, new String[0]);
            if (!path.isAbsolute()) {
                path = Paths.get(this.build.getDirectory(), new String[0]).resolve(path);
            }
            TestExecutionListener[] testExecutionListenerArray = new TestExecutionListener[1];
            testExecutionListenerArray[0] = new XmlReportsWritingListener(path, (arg_0, arg_1) -> ((Log)this.log).error(arg_0, arg_1));
            this.launcher.registerTestExecutionListeners(testExecutionListenerArray);
        }
        this.launcher.execute(this.request, new TestExecutionListener[0]);
        return summary.getSummary();
    }
}

