/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Configuration;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformLauncher;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.IntSupplier;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class JUnitPlatformCaller
implements IntSupplier {
    private final ClassLoader classLoader;
    private final JUnitPlatformLauncher launcher;
    private final Log log;
    private final long timeout;

    public JUnitPlatformCaller(ClassLoader classLoader, Configuration configuration) {
        this.classLoader = classLoader;
        this.launcher = new JUnitPlatformLauncher(configuration);
        this.log = configuration.getLog();
        this.timeout = configuration.getTimeout().toMillis();
    }

    @Override
    public int getAsInt() {
        ClassLoader oldContext = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int n = this.launch();
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContext);
        }
    }

    private int launch() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<TestExecutionSummary> future = executor.submit(this.launcher);
        try {
            return this.summarize(future.get(this.timeout, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)"Launcher execution interrupted", (Throwable)e);
            return -1;
        }
        catch (ExecutionException e) {
            throw JUnitPlatformCaller.rethrow(e.getCause());
        }
        catch (TimeoutException e) {
            this.log.error((CharSequence)("Global timeout reached: " + this.timeout + " millis"), (Throwable)e);
            return -2;
        }
    }

    private int summarize(TestExecutionSummary summary) {
        boolean success;
        long duration = summary.getTimeFinished() - summary.getTimeStarted();
        boolean bl = success = summary.getTestsFailedCount() == 0L && summary.getContainersFailedCount() == 0L;
        if (success) {
            long succeeded = summary.getTestsSucceededCount();
            String s = succeeded == 1L ? "" : "s";
            this.log.info((CharSequence)MessageUtils.buffer().a((CharSequence)"Successfully executed ").success((Object)succeeded).a((CharSequence)(" test" + s + " in ")).a((Object)duration).a((CharSequence)" ms").toString());
        } else {
            StringWriter message = new StringWriter();
            PrintWriter writer = new PrintWriter(message);
            summary.printTo(writer);
            summary.printFailuresTo(writer);
            for (String line : message.toString().split("\\R")) {
                this.log.error((CharSequence)line);
            }
        }
        return success ? 0 : 1;
    }

    private static UndeclaredThrowableException rethrow(Throwable cause) {
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return new UndeclaredThrowableException(cause);
    }
}

