/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Configuration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.IntSupplier;
import org.apache.maven.plugin.logging.Log;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class Task
implements IntSupplier {
    private final ClassLoader classLoader;
    private final Configuration configuration;

    public Task(ClassLoader classLoader, Configuration configuration) {
        this.classLoader = classLoader;
        this.configuration = configuration;
    }

    @Override
    public int getAsInt() {
        ClassLoader oldContext = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int n = Task.launchJUnitPlatform(this.configuration);
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContext);
        }
    }

    private static int launchJUnitPlatform(Configuration configuration) {
        boolean success;
        Log log = configuration.getLog();
        log.info((CharSequence)"Launching JUnit Platform...");
        log.info((CharSequence)"");
        log.debug((CharSequence)("project: " + configuration.getMavenProject()));
        log.debug((CharSequence)("timeout: " + configuration.getTimeout().getSeconds()));
        log.debug((CharSequence)("parameters: " + configuration.getParameters()));
        log.debug((CharSequence)"");
        HashSet<Path> roots = new HashSet<Path>();
        roots.add(Paths.get(configuration.getMavenProject().getBuild().getTestOutputDirectory(), new String[0]));
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : configuration.getParameters().entrySet()) {
            parameters.put((String)entry.getKey(), (String)entry.getValue());
        }
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(roots)).configurationParameters(parameters).build();
        Launcher launcher = LauncherFactory.create();
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        long startTimeMillis = System.currentTimeMillis();
        launcher.execute(request, new TestExecutionListener[0]);
        long duration = System.currentTimeMillis() - startTimeMillis;
        TestExecutionSummary summary = listener.getSummary();
        boolean bl = success = summary.getTestsFailedCount() == 0L && summary.getTestsAbortedCount() == 0L && summary.getContainersFailedCount() == 0L && summary.getContainersAbortedCount() == 0L;
        if (success) {
            long succeeded = summary.getTestsSucceededCount();
            log.info((CharSequence)String.format("Successfully executed: %d test(s) in %d ms", succeeded, duration));
        } else {
            StringWriter message = new StringWriter();
            PrintWriter writer = new PrintWriter(message);
            summary.printTo(writer);
            summary.printFailuresTo(writer);
            for (String line : message.toString().split("\\R")) {
                log.error((CharSequence)line);
            }
        }
        return success ? 0 : 1;
    }
}

