/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Configuration;
import de.sormuras.junit.platform.maven.plugin.Task;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import java.util.function.IntSupplier;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="launch-junit-platform", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnitPlatformMavenPluginMojo
extends AbstractMojo
implements Configuration {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="100", readonly=true, required=true)
    private long timeout;
    @Parameter(readonly=true)
    private Properties parameters = new Properties();

    @Override
    public MavenProject getMavenProject() {
        return this.project;
    }

    @Override
    public Duration getTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    @Override
    public Properties getParameters() {
        return this.parameters;
    }

    public void execute() throws MojoExecutionException {
        ClassLoader loader = this.createClassLoader();
        Class<?> taskClass = JUnitPlatformMavenPluginMojo.load(loader, Task.class);
        Class[] taskTypes = new Class[]{ClassLoader.class, Configuration.class};
        IntSupplier task = (IntSupplier)JUnitPlatformMavenPluginMojo.create(taskClass, taskTypes, loader, this);
        int result = task.getAsInt();
        if (result != 0) {
            throw new MojoExecutionException("RED ALERT!");
        }
    }

    private ClassLoader createClassLoader() throws MojoExecutionException {
        URL[] urls;
        ClassLoader parent = this.getClass().getClassLoader();
        try {
            List elements = this.project.getTestClasspathElements();
            urls = new URL[this.project.getTestClasspathElements().size()];
            for (int i = 0; i < elements.size(); ++i) {
                urls[i] = Paths.get((String)elements.get(i), new String[0]).toAbsolutePath().normalize().toUri().toURL();
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Resolving test class-path elements failed", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Malformed URL caught: ", (Exception)e);
        }
        return URLClassLoader.newInstance(urls, parent);
    }

    private static Class<?> load(ClassLoader loader, Class<?> type) {
        String name = type.getName();
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Object create(Class<?> type, Class<?>[] parameterTypes, Object ... args) {
        try {
            return type.getConstructor(parameterTypes).newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw JUnitPlatformMavenPluginMojo.rethrow(e.getCause());
        }
    }

    private static UndeclaredThrowableException rethrow(Throwable cause) {
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return new UndeclaredThrowableException(cause);
    }
}

