/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.FileNames;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import de.sormuras.junit.platform.maven.plugin.Modules;
import de.sormuras.junit.platform.maven.plugin.Patcher;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

class Starter
implements IntSupplier {
    private final JUnitPlatformMojo mojo;
    private final MavenProject project;
    private final Modules modules;

    Starter(JUnitPlatformMojo mojo) {
        this.mojo = mojo;
        this.project = mojo.getMavenProject();
        this.modules = mojo.getProjectModules();
    }

    private void debug(String format, Object ... args) {
        this.mojo.debug(String.format(format, args), new Object[0]);
    }

    @Override
    public int getAsInt() {
        Log log = this.mojo.getLog();
        FileNames names = this.mojo.getFileNames();
        Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("junit-platform");
        Path cmdPath = target.resolve(names.getConsoleLauncherCmdLog());
        Path errorPath = target.resolve(names.getConsoleLauncherErrLog());
        Path outputPath = target.resolve(names.getConsoleLauncherOutLog());
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        List<String> cmd = builder.command();
        builder.redirectError(errorPath.toFile());
        builder.redirectOutput(outputPath.toFile());
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        cmd.add(this.mojo.getJavaExecutable());
        this.mojo.getOverrideJavaOptions().ifPresentOrElse(cmd::addAll, () -> this.addJavaOptions(cmd));
        this.mojo.getOverrideLauncherOptions().ifPresentOrElse(cmd::addAll, () -> this.addLauncherOptions(cmd));
        try {
            Files.createDirectories(target, new FileAttribute[0]);
            Files.write(cmdPath, cmd, new OpenOption[0]);
            if (Files.notExists(errorPath, new LinkOption[0])) {
                Files.createFile(errorPath, new FileAttribute[0]);
            }
            if (Files.notExists(outputPath, new LinkOption[0])) {
                Files.createFile(outputPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("Preparing target path failed: " + target), (Throwable)e);
        }
        if (this.mojo.isDryRun()) {
            this.mojo.getLog().info((CharSequence)"Dry-run mode is active -- only printing command line");
            cmd.forEach(arg_0 -> ((Log)this.mojo.getLog()).info(arg_0));
            return 0;
        }
        this.debug("", new Object[0]);
        this.debug("Starting process...", new Object[0]);
        cmd.forEach(x$0 -> this.mojo.debug((String)x$0, new Object[0]));
        try {
            long timeout = this.mojo.getTimeout().toSeconds();
            Process process = builder.start();
            this.debug("Process started: #%d %s", process.pid(), process.info());
            boolean ok = process.waitFor(timeout, TimeUnit.SECONDS);
            if (!ok) {
                String s = timeout == 1L ? "" : "s";
                log.error((CharSequence)("Global timeout of " + timeout + " second" + s + " reached."));
                log.error((CharSequence)("Killing process #" + process.pid()));
                process.destroy();
                return -2;
            }
            int exitValue = process.exitValue();
            try {
                Files.readAllLines(outputPath).stream().limit(500L).forEach(exitValue == 0 ? arg_0 -> ((Log)log).info(arg_0) : arg_0 -> ((Log)log).error(arg_0));
                Files.readAllLines(errorPath).forEach(exitValue == 0 ? arg_0 -> ((Log)log).warn(arg_0) : arg_0 -> ((Log)log).error(arg_0));
            }
            catch (IOException e) {
                log.warn((CharSequence)"Reading output/error logs failed", (Throwable)e);
            }
            return exitValue;
        }
        catch (IOException | InterruptedException e) {
            log.error((CharSequence)"Executing process failed", (Throwable)e);
            return -1;
        }
    }

    private void addJavaOptions(List<String> cmd) {
        Optional<ModuleReference> mainModule = this.modules.getMainModuleReference();
        Optional<ModuleReference> testModule = this.modules.getTestModuleReference();
        cmd.addAll(this.mojo.getJavaOptions().getAdditionalOptions());
        cmd.add("-enableassertions");
        cmd.add("-Dfile.encoding=UTF-8");
        if (mainModule.isPresent() || testModule.isPresent()) {
            cmd.add("--module-path");
            cmd.add(this.createPathArgument());
            cmd.add("--add-modules");
            cmd.add(this.createAddModulesArgument());
            if (mainModule.isPresent() && !testModule.isPresent()) {
                new Patcher(this.mojo).patch(cmd);
            }
            cmd.add("--module");
            cmd.add("org.junit.platform.console");
        } else {
            cmd.add("--class-path");
            cmd.add(this.createPathArgument());
            cmd.add("org.junit.platform.console.ConsoleLauncher");
        }
    }

    private void addLauncherOptions(List<String> cmd) {
        cmd.add("--disable-ansi-colors");
        cmd.add("--details");
        cmd.add("tree");
        cmd.add("--details-theme");
        cmd.add("ascii");
        this.mojo.getTags().forEach(tag -> cmd.add(Starter.createTagArgument(tag)));
        this.mojo.getParameters().forEach((key, value) -> cmd.add(Starter.createConfigArgument(key, value)));
        this.mojo.getReportsPath().ifPresent(path -> {
            cmd.add("--reports-dir");
            cmd.add(path.toString());
        });
        Optional<ModuleReference> mainModule = this.modules.getMainModuleReference();
        Optional<ModuleReference> testModule = this.modules.getTestModuleReference();
        if (testModule.isPresent()) {
            cmd.add("--select-module");
            cmd.add(testModule.get().descriptor().name());
        } else if (mainModule.isPresent()) {
            cmd.add("--select-module");
            cmd.add(mainModule.get().descriptor().name());
        } else {
            cmd.add("--scan-class-path");
        }
    }

    private String createAddModulesArgument() {
        String value = this.mojo.getJavaOptions().getAddModules();
        if (value != null) {
            return value;
        }
        switch (this.modules.getMode()) {
            case MODULAR_PATCHED_TEST_RUNTIME: {
                return this.modules.getMainModuleReference().orElseThrow().descriptor().name();
            }
        }
        return this.modules.getTestModuleReference().orElseThrow().descriptor().name();
    }

    private static String createConfigArgument(String key, String value) {
        return "--config=\"" + key + "\"=\"" + value + "\"";
    }

    private static String createTagArgument(String tag) {
        return "--include-tag=\"" + tag + "\"";
    }

    private String createPathArgument() {
        String delimiter = File.pathSeparator;
        return this.mojo.getProjectPaths().stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }
}

