/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Dependencies;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

class Resolver {
    private final JUnitPlatformMojo mojo;
    private final List<Path> paths;
    private final MavenProject project;

    Resolver(JUnitPlatformMojo mojo) {
        this.mojo = mojo;
        this.project = mojo.getMavenProject();
        this.paths = this.buildPaths();
    }

    private List<Path> buildPaths() {
        org.apache.maven.artifact.Artifact junit;
        PathsBuilder builder = new PathsBuilder();
        builder.append(this.project.getBuild().getTestOutputDirectory(), new String[0]);
        builder.append(this.project.getBuild().getOutputDirectory(), new String[0]);
        for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            builder.append(file.toPath());
        }
        if (this.contains(Dependencies.GroupArtifact.JUNIT_JUPITER_API)) {
            builder.append(Dependencies.GroupArtifact.JUNIT_JUPITER_ENGINE);
        }
        if ((junit = (org.apache.maven.artifact.Artifact)this.project.getArtifactMap().get("junit:junit")) != null && "4.12".equals(junit.getVersion())) {
            builder.append(Dependencies.GroupArtifact.JUNIT_VINTAGE_ENGINE);
        }
        builder.append(Dependencies.GroupArtifact.JUNIT_PLATFORM_CONSOLE);
        return builder.build();
    }

    private boolean contains(Dependencies.GroupArtifact ga) {
        return this.contains(ga.toIdentifier());
    }

    private boolean contains(String ga) {
        return this.project.getArtifactMap().containsKey(ga);
    }

    private void resolve(Dependencies.GroupArtifact ga, Consumer<Path> list) throws DependencyResolutionException {
        if (this.contains(ga)) {
            this.verbose("Skip resolving '%s', because it is already mapped.", new Object[]{ga});
            return;
        }
        String gav = ga.toIdentifier() + ":" + this.mojo.version(ga.getVersion());
        this.verbose("", new Object[0]);
        this.verbose("Resolving '%s' and its transitive dependencies...", gav);
        for (Artifact resolved : this.resolve(gav)) {
            String key = resolved.getGroupId() + ":" + resolved.getArtifactId();
            if (this.contains(key)) {
                this.verbose("  X %s // mapped by project", resolved);
                continue;
            }
            list.accept(resolved.getFile().toPath().toAbsolutePath().normalize());
        }
    }

    private List<Artifact> resolve(String coordinates) throws DependencyResolutionException {
        ArrayList repositories = new ArrayList();
        repositories.addAll(this.project.getRemotePluginRepositories());
        repositories.addAll(this.project.getRemoteProjectRepositories());
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        this.verbose("Resolving artifact %s from %s...", artifact, repositories);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(repositories);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
        collectRequest.setRepositories(repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (all, ways) -> true);
        RepositorySystemSession session = this.mojo.getMavenRepositorySession();
        this.verbose("Resolving dependencies %s...", dependencyRequest);
        return this.mojo.getMavenResolver().resolveDependencies(session, dependencyRequest).getArtifactResults().stream().map(ArtifactResult::getArtifact).peek(a -> this.verbose("Artifact %s resolved to %s", a, a.getFile())).collect(Collectors.toList());
    }

    List<Path> getPaths() {
        return this.paths;
    }

    private void verbose(String format, Object ... args) {
        if (this.mojo.isVerbose()) {
            this.mojo.getLog().debug((CharSequence)String.format(format, args));
        }
    }

    private class PathsBuilder {
        final List<Path> paths = new ArrayList<Path>();

        private PathsBuilder() {
        }

        void append(Path path) {
            if (Files.notExists(path, new LinkOption[0])) {
                Resolver.this.verbose("  X %s // does not exist", new Object[]{path});
                return;
            }
            if (this.paths.contains(path)) {
                Resolver.this.verbose("  X %s // already added", new Object[]{path});
                return;
            }
            Resolver.this.verbose(" -> %s", new Object[]{path});
            this.paths.add(path);
        }

        void append(String first, String ... more) {
            this.append(Paths.get(first, more));
        }

        void append(Dependencies.GroupArtifact ga) {
            try {
                Resolver.this.resolve(ga, this::append);
            }
            catch (DependencyResolutionException e) {
                Resolver.this.mojo.getLog().warn((CharSequence)("Resolving " + ga + " failed"), (Throwable)e);
            }
        }

        List<Path> build() {
            return List.copyOf(this.paths);
        }
    }
}

