/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin.testing;

import de.sormuras.junit.platform.maven.plugin.testing.TestBarrier;

public enum TestMode {
    CLASSIC(TestBarrier.PACKAGE),
    MAIN_CLASSIC_TEST_MODULE(TestBarrier.MODULE),
    MAIN_MODULE_TEST_CLASSIC(TestBarrier.PACKAGE),
    MAIN_MODULE_TEST_MODULE_SAME_NAME(TestBarrier.PACKAGE),
    MODULAR(TestBarrier.MODULE);

    final TestBarrier barrier;

    private TestMode(TestBarrier barrier) {
        this.barrier = barrier;
    }

    public static TestMode of(String main, String test) {
        if (main == null) {
            if (test == null) {
                return CLASSIC;
            }
            return MAIN_CLASSIC_TEST_MODULE;
        }
        if (test == null) {
            return MAIN_MODULE_TEST_CLASSIC;
        }
        if (main.equals(test)) {
            return MAIN_MODULE_TEST_MODULE_SAME_NAME;
        }
        return MODULAR;
    }

    public String toString() {
        return this.name() + " [barrier=" + this.barrier + "]";
    }
}

