/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

class Dependencies {
    Dependencies() {
    }

    static Map<String, String> createArtifactVersionMap(UnaryOperator<String> versionOperator) {
        HashMap<String, String> result = new HashMap<String, String>();
        block0: for (Version version : Version.values()) {
            String versionKey = version.getKey();
            for (GroupArtifact groupArtifact : version.getGroupArtifacts()) {
                String artifactVersion = (String)versionOperator.apply(groupArtifact.toIdentifier());
                if (artifactVersion == null) continue;
                result.put(versionKey, artifactVersion);
                continue block0;
            }
            result.put(versionKey, version.getDefaultVersion());
        }
        return result;
    }

    static void forEachVersion(Consumer<Version> versionConsumer) {
        Arrays.stream(Version.values()).sorted().forEach(versionConsumer);
    }

    static enum Version {
        JUNIT_JUPITER_VERSION("5.3.0", GroupArtifact.JUNIT_JUPITER_API, GroupArtifact.JUNIT_JUPITER_ENGINE),
        JUNIT_PLATFORM_VERSION("1.3.0", GroupArtifact.JUNIT_PLATFORM_COMMONS),
        JUNIT_VINTAGE_VERSION("5.3.0", GroupArtifact.JUNIT_VINTAGE_ENGINE);

        private final String key = this.name().toLowerCase().replace('_', '.');
        private final String defaultVersion;
        private final List<GroupArtifact> groupArtifacts;

        private Version(String defaultVersion, GroupArtifact ... groupArtifacts) {
            this.defaultVersion = defaultVersion;
            this.groupArtifacts = List.of(groupArtifacts);
        }

        List<GroupArtifact> getGroupArtifacts() {
            return this.groupArtifacts;
        }

        String getKey() {
            return this.key;
        }

        String getDefaultVersion() {
            return this.defaultVersion;
        }
    }

    static enum GroupArtifact {
        JUNIT_JUPITER_API("org.junit.jupiter", "junit-jupiter-api", "JUNIT_JUPITER"),
        JUNIT_JUPITER_ENGINE("org.junit.jupiter", "junit-jupiter-engine", "JUNIT_JUPITER"),
        JUNIT_PLATFORM_COMMONS("org.junit.platform", "junit-platform-commons", "JUNIT_PLATFORM"),
        JUNIT_PLATFORM_CONSOLE("org.junit.platform", "junit-platform-console", "JUNIT_PLATFORM"),
        JUNIT_VINTAGE_ENGINE("org.junit.vintage", "junit-vintage-engine", "JUNIT_VINTAGE");

        private final String artifact;
        private final String group;
        private final String versionName;

        private GroupArtifact(String group, String artifact, String versionBaseName) {
            this.group = group;
            this.artifact = artifact;
            this.versionName = versionBaseName + "_VERSION";
        }

        String getArtifact() {
            return this.artifact;
        }

        String getGroup() {
            return this.group;
        }

        Version getVersion() {
            return Version.valueOf(this.versionName);
        }

        String toIdentifier() {
            return this.getGroup() + ":" + this.getArtifact();
        }
    }
}

