/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.brahms.resource;

import de.sormuras.brahms.resource.ResourceSupplier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.ReflectionSupport;

public class ResourceManager
implements ParameterResolver,
BeforeAllCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ResourceManager.class});

    public void beforeAll(ExtensionContext extension) throws Exception {
        Class testClass = extension.getRequiredTestClass();
        ExtensionContext.Store classStore = extension.getStore(NAMESPACE);
        for (Field field : testClass.getDeclaredFields()) {
            if (field.isSynthetic() || !field.isAnnotationPresent(Closeable.class)) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new JUnitException("Annotated field must be static: " + field);
            }
            if (field.trySetAccessible()) {
                Object instance = field.get(testClass);
                InstanceSupplier<Object> supplier = new InstanceSupplier<Object>(instance);
                classStore.getOrComputeIfAbsent((Object)field.toString(), k -> supplier);
                continue;
            }
            throw new JUnitException("Can't make field accessible: " + field);
        }
    }

    public boolean supportsParameter(ParameterContext parameter, ExtensionContext __) {
        return parameter.isAnnotated(New.class) ^ parameter.isAnnotated(Singleton.class);
    }

    public Object resolveParameter(ParameterContext parameter, ExtensionContext extension) {
        ResourceSupplier<?> supplier = this.supplier(parameter, extension);
        Class<?> parameterType = parameter.getParameter().getType();
        if (ResourceSupplier.class.isAssignableFrom(parameterType)) {
            return supplier;
        }
        Object instance = supplier.get();
        if (parameterType.isAssignableFrom(instance.getClass())) {
            return instance;
        }
        throw new ParameterResolutionException("Parameter type " + parameterType + " isn't compatible with " + ResourceSupplier.class + " nor " + instance.getClass());
    }

    private ResourceSupplier<?> supplier(ParameterContext parameter, ExtensionContext context) {
        Optional newAnnotation = parameter.findAnnotation(New.class);
        if (newAnnotation.isPresent()) {
            Class<ResourceSupplier<?>> type = ((New)newAnnotation.get()).value();
            String key = type.getName() + "@" + parameter.getIndex();
            ResourceSupplier instance = (ResourceSupplier)ReflectionSupport.newInstance(type, (Object[])new Object[0]);
            context.getStore(NAMESPACE).put((Object)key, (Object)instance);
            return instance;
        }
        Optional singletonAnnotation = parameter.findAnnotation(Singleton.class);
        if (singletonAnnotation.isPresent()) {
            Class<ResourceSupplier<?>> supplier = ((Singleton)singletonAnnotation.get()).value();
            String key = supplier.getName();
            ResourceSupplier instance = (ResourceSupplier)context.getStore(NAMESPACE).get((Object)key, ResourceSupplier.class);
            if (instance != null) {
                return instance;
            }
            return (ResourceSupplier)context.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)key, k -> (ResourceSupplier)ReflectionSupport.newInstance((Class)supplier, (Object[])new Object[0]), ResourceSupplier.class);
        }
        throw new ParameterResolutionException("Can't resolve resource supplier for: " + parameter);
    }

    static class InstanceSupplier<R>
    implements ResourceSupplier<R> {
        private final R instance;

        InstanceSupplier(R instance) {
            this.instance = instance;
        }

        @Override
        public R get() {
            return this.instance;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Singleton {
        public Class<? extends ResourceSupplier<?>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface New {
        public Class<? extends ResourceSupplier<?>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Closeable {
    }
}

