/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.brahms.resource;

import de.sormuras.brahms.resource.ResourceSupplier;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class Temporary
implements ResourceSupplier<Path> {
    private final Path path;

    public Temporary() {
        try {
            this.path = this.createTempDirectory();
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Creating temporary directory failed", (Throwable)e);
        }
    }

    protected Path createTempDirectory() throws Exception {
        return Files.createTempDirectory("Temporary-", new FileAttribute[0]);
    }

    @Override
    public Path get() {
        return this.path;
    }

    @Override
    public void close() {
        if (Files.notExists(this.path, new LinkOption[0])) {
            return;
        }
        try {
            try {
                Files.delete(this.path);
                return;
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                try (Stream<Path> stream = Files.walk(this.path, new FileVisitOption[0]);){
                    Stream<Path> selected = stream.sorted((p, q) -> -p.compareTo((Path)q));
                    for (Path path : selected.collect(Collectors.toList())) {
                        Files.deleteIfExists(path);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("deleting temporary path failed: " + this.path, e);
        }
    }
}

