/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.brahms.resource;

import de.sormuras.brahms.resource.ResourceSupplier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class ResourceManager
implements ParameterResolver,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ResourceManager.class});
    private static final AtomicLong NEW_COUNTER = new AtomicLong();
    private final Map<String, Set<ResourceSupplier<?>>> registry = new ConcurrentHashMap();

    public boolean supportsParameter(ParameterContext parameter, ExtensionContext __) {
        return parameter.isAnnotated(New.class) ^ parameter.isAnnotated(Shared.class) ^ parameter.isAnnotated(Singleton.class);
    }

    public Object resolveParameter(ParameterContext parameter, ExtensionContext extension) {
        ResourceSupplier<?> supplier = this.supplier(parameter, extension);
        Class<?> parameterType = parameter.getParameter().getType();
        if (ResourceSupplier.class.isAssignableFrom(parameterType)) {
            return supplier;
        }
        Object instance = supplier.get();
        if (parameterType.isAssignableFrom(instance.getClass())) {
            return instance;
        }
        try {
            return supplier.as(parameterType);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ParameterResolutionException("parameter type " + parameterType + " isn't compatible with " + ResourceSupplier.class + " nor " + instance.getClass());
        }
    }

    private ResourceSupplier<?> supplier(ParameterContext parameter, ExtensionContext context) {
        Optional newAnnotation = parameter.findAnnotation(New.class);
        if (newAnnotation.isPresent()) {
            Class<ResourceSupplier<?>> type = ((New)newAnnotation.get()).value();
            String key = type.getName() + "@" + NEW_COUNTER.incrementAndGet();
            ResourceSupplier resourceSupplier = (ResourceSupplier)ReflectionSupport.newInstance(type, (Object[])new Object[0]);
            assert (context.getStore(NAMESPACE).get((Object)key) == null);
            context.getStore(NAMESPACE).put((Object)key, (Object)resourceSupplier);
            if (parameter.getDeclaringExecutable() instanceof Constructor) {
                String registryKey = parameter.getDeclaringExecutable().getDeclaringClass().getName();
                this.registry.computeIfAbsent(registryKey, k -> new HashSet()).add(resourceSupplier);
            }
            return resourceSupplier;
        }
        Optional sharedAnnotation = parameter.findAnnotation(Shared.class);
        if (sharedAnnotation.isPresent()) {
            Class<? extends ResourceSupplier<?>> type = ((Shared)sharedAnnotation.get()).type();
            String key = ((Shared)sharedAnnotation.get()).name();
            return this.supplier(context, key, type);
        }
        Optional singletonAnnotation = parameter.findAnnotation(Singleton.class);
        if (singletonAnnotation.isPresent()) {
            Class<ResourceSupplier<?>> type = ((Singleton)singletonAnnotation.get()).value();
            String key = type.getName();
            return this.supplier(context, key, type);
        }
        throw new ParameterResolutionException("Can't resolve resource supplier for: " + parameter);
    }

    private ResourceSupplier<?> supplier(ExtensionContext context, String key, Class<? extends ResourceSupplier<?>> type) {
        ExtensionContext.Store store = context.getRoot().getStore(NAMESPACE);
        return (ResourceSupplier)store.getOrComputeIfAbsent((Object)key, k -> (ResourceSupplier)ReflectionSupport.newInstance((Class)type, (Object[])new Object[0]), ResourceSupplier.class);
    }

    public void afterEach(ExtensionContext context) {
        if (context.getTestInstanceLifecycle().isEmpty()) {
            return;
        }
        TestInstance.Lifecycle lifecycle = (TestInstance.Lifecycle)context.getTestInstanceLifecycle().get();
        if (lifecycle == TestInstance.Lifecycle.PER_CLASS) {
            return;
        }
        Set suppliers = this.registry.getOrDefault(context.getRequiredTestClass().getName(), Set.of());
        if (suppliers.isEmpty()) {
            return;
        }
        Optional optionalTestClass = context.getTestClass();
        if (optionalTestClass.isEmpty()) {
            return;
        }
        for (Field field : ReflectionSupport.findFields((Class)((Class)optionalTestClass.get()), __ -> true, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN)) {
            Object value = ReflectionSupport.tryToReadFieldValue((Field)field, (Object)context.getRequiredTestInstance()).getOrThrow(RuntimeException::new);
            for (ResourceSupplier supplier : suppliers) {
                if (supplier != value && supplier.get() != value) continue;
                context.publishReportEntry("closing resource", supplier.get().toString());
                try {
                    supplier.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("closing resource supplier failed", e);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Singleton {
        public Class<? extends ResourceSupplier<?>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Shared {
        public String name();

        public Class<? extends ResourceSupplier<?>> type();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    public static @interface New {
        public Class<? extends ResourceSupplier<?>> value();
    }
}

