/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.brahms.maingine;

import de.sormuras.brahms.maingine.Main;
import de.sormuras.brahms.maingine.MainClass;
import de.sormuras.brahms.maingine.MainMethod;
import java.io.IOException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.filter.ClasspathScanningSupport;

public class MainTestEngine
implements TestEngine {
    static String ENGINE_ID = "brahms-maingine";
    static String ENGINE_DISPLAY_NAME = "Brahms Maingine";

    public String getId() {
        return ENGINE_ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        EngineDescriptor engine = new EngineDescriptor(uniqueId, ENGINE_DISPLAY_NAME);
        ClassFilter classFilter = ClassFilter.of((Predicate)ClasspathScanningSupport.buildClassNamePredicate((EngineDiscoveryRequest)discoveryRequest), c -> true);
        discoveryRequest.getSelectorsByType(ClasspathRootSelector.class).stream().map(ClasspathRootSelector::getClasspathRoot).map(uri -> ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, (ClassFilter)classFilter)).flatMap(Collection::stream).forEach(candidate -> this.handleCandidate(engine, (Class<?>)candidate));
        discoveryRequest.getSelectorsByType(PackageSelector.class).stream().map(PackageSelector::getPackageName).map(packageName -> ReflectionUtils.findAllClassesInPackage((String)packageName, (ClassFilter)classFilter)).flatMap(Collection::stream).forEach(candidate -> this.handleCandidate(engine, (Class<?>)candidate));
        discoveryRequest.getSelectorsByType(ClassSelector.class).stream().map(ClassSelector::getJavaClass).filter((Predicate<Class>)classFilter).forEach(candidate -> this.handleCandidate(engine, (Class<?>)candidate));
        return engine;
    }

    private void handleCandidate(EngineDescriptor engine, Class<?> candidate) {
        Method main;
        try {
            main = candidate.getDeclaredMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        if (!ReflectionUtils.isPublic((Member)main)) {
            return;
        }
        if (!ReflectionUtils.isStatic((Member)main)) {
            return;
        }
        if (!ReflectionUtils.returnsVoid((Method)main)) {
            return;
        }
        MainClass container = MainClass.of(candidate, (TestDescriptor)engine);
        Main[] annotations = (Main[])main.getDeclaredAnnotationsByType(Main.class);
        if (annotations.length == 0) {
            UniqueId id = container.getUniqueId().append("main", "main0");
            container.addChild((TestDescriptor)new MainMethod(id, main));
            return;
        }
        for (Main annotation : annotations) {
            UniqueId id = container.getUniqueId().append("main", "main" + System.identityHashCode(annotation));
            container.addChild((TestDescriptor)new MainMethod(id, main, annotation));
        }
    }

    public void execute(ExecutionRequest request) {
        TestDescriptor engine = request.getRootTestDescriptor();
        EngineExecutionListener listener = request.getEngineExecutionListener();
        listener.executionStarted(engine);
        for (TestDescriptor mainClass : engine.getChildren()) {
            listener.executionStarted(mainClass);
            for (TestDescriptor mainMethod : mainClass.getChildren()) {
                listener.executionStarted(mainMethod);
                TestExecutionResult result = this.executeMainMethod((MainMethod)mainMethod);
                listener.executionFinished(mainMethod, result);
            }
            listener.executionFinished(mainClass, TestExecutionResult.successful());
        }
        listener.executionFinished(engine, TestExecutionResult.successful());
    }

    private TestExecutionResult executeMainMethod(MainMethod mainMethod) {
        return mainMethod.isFork() ? this.executeForked(mainMethod) : this.executeDirect(mainMethod);
    }

    private TestExecutionResult executeDirect(MainMethod mainMethod) {
        try {
            Method method = mainMethod.getMethod();
            Object[] arguments = new Object[]{mainMethod.getArguments()};
            method.invoke(null, arguments);
        }
        catch (Throwable t) {
            return TestExecutionResult.failed((Throwable)t);
        }
        return TestExecutionResult.successful();
    }

    private TestExecutionResult executeForked(MainMethod mainMethod) {
        ProcessBuilder builder = new ProcessBuilder(MainTestEngine.java().normalize().toAbsolutePath().toString());
        List<String> command = builder.command();
        Arrays.stream(mainMethod.getOptions()).map(MainTestEngine::replaceSystemProperties).forEach(command::add);
        command.add(mainMethod.getMethod().getDeclaringClass().getName());
        command.addAll(List.of(mainMethod.getArguments()));
        builder.inheritIO();
        try {
            Process process = builder.start();
            int actualExitValue = process.waitFor();
            int expectedExitValue = mainMethod.getExpectedExitValue();
            if (actualExitValue != expectedExitValue) {
                String message = "expected exit value " + expectedExitValue + ", but got: " + actualExitValue;
                return TestExecutionResult.failed((Throwable)new IllegalStateException(message));
            }
        }
        catch (IOException | InterruptedException e) {
            return TestExecutionResult.failed((Throwable)e);
        }
        return TestExecutionResult.successful();
    }

    private static Path java() {
        return ProcessHandle.current().info().command().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow();
    }

    private static String replaceSystemProperties(String string) {
        string = MainTestEngine.replaceSystemProperty(string, "java.class.path");
        string = MainTestEngine.replaceSystemProperty(string, "jdk.module.path");
        return string;
    }

    private static String replaceSystemProperty(String string, String key) {
        String replacement = System.getProperty(key);
        if (replacement == null) {
            return string;
        }
        return string.replace("${" + key + "}", replacement);
    }
}

