/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.brahms.sifisoco;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.descriptor.FileSource;

public class SingleFileSourceCodeTestEngine
implements TestEngine {
    static String ENGINE_ID = "brahms-sifisoco";
    static String ENGINE_DISPLAY_NAME = "Brahms Single-File Source-Code Engine (JEP 330)";
    static Pattern PUBLIC_STATIC_VOID_MAIN_PATTERN = Pattern.compile(".+(?:public\\s+)?static\\s+void\\s+main.+String.+", 32);
    private final Path java = SingleFileSourceCodeTestEngine.getCurrentJavaExecutablePath();

    private static boolean isSingleFileSourceCodeProgram(Path path, BasicFileAttributes attributes) {
        if (!attributes.isRegularFile()) {
            return false;
        }
        if (attributes.size() < 42L) {
            return false;
        }
        if (!path.toString().endsWith(".java")) {
            return false;
        }
        try {
            String code = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            if (!PUBLIC_STATIC_VOID_MAIN_PATTERN.matcher(code).matches()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static Path getCurrentJavaExecutablePath() {
        Path path = ProcessHandle.current().info().command().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow();
        return path.normalize().toAbsolutePath();
    }

    public String getId() {
        return ENGINE_ID;
    }

    public EngineDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        EngineDescriptor engine = new EngineDescriptor(uniqueId, ENGINE_DISPLAY_NAME);
        Scanner scanner = new Scanner(engine);
        scanner.scanJavaClassPath();
        return engine;
    }

    public void execute(ExecutionRequest request) {
        org.junit.platform.engine.TestDescriptor engine = request.getRootTestDescriptor();
        EngineExecutionListener listener = request.getEngineExecutionListener();
        listener.executionStarted(engine);
        for (org.junit.platform.engine.TestDescriptor descriptor : engine.getChildren()) {
            listener.executionStarted(descriptor);
            TestDescriptor test = (TestDescriptor)descriptor;
            TestExecutionResult result = this.execute(test.path);
            listener.executionFinished(descriptor, result);
        }
        listener.executionFinished(engine, TestExecutionResult.successful());
    }

    private TestExecutionResult execute(Path program) {
        if (Runtime.version().feature() < 11) {
            AssertionError error = new AssertionError((Object)("Java 11 or higher required, running: " + Runtime.version()));
            return TestExecutionResult.aborted((Throwable)((Object)error));
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command().add(this.java.toString());
        builder.command().add(program.getFileName().toString());
        builder.directory(program.getParent().toFile());
        builder.inheritIO();
        try {
            Process process = builder.start();
            int actualExitValue = process.waitFor();
            int expectedExitValue = 0;
            if (actualExitValue != expectedExitValue) {
                String message = "expected exit value " + expectedExitValue + ", but got: " + actualExitValue;
                return TestExecutionResult.failed((Throwable)new IllegalStateException(message));
            }
        }
        catch (IOException | InterruptedException e) {
            return TestExecutionResult.failed((Throwable)e);
        }
        return TestExecutionResult.successful();
    }

    private static class TestDescriptor
    extends AbstractTestDescriptor {
        final Path path;

        TestDescriptor(UniqueId uniqueId, Path path) {
            super(uniqueId, path.getFileName().toString(), (TestSource)FileSource.from((File)path.toFile()));
            this.path = path;
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }
    }

    private static class Scanner {
        final EngineDescriptor engine;

        Scanner(EngineDescriptor engine) {
            this.engine = engine;
        }

        void scanJavaClassPath() {
            String[] roots = System.getProperty("java.class.path").split(Pattern.quote(File.pathSeparator));
            Arrays.stream(roots).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this::scanDirectory);
        }

        private void scanDirectory(Path path) {
            try {
                Files.find(path, 1, (x$0, x$1) -> SingleFileSourceCodeTestEngine.isSingleFileSourceCodeProgram(x$0, x$1), new FileVisitOption[0]).forEach(this::add);
            }
            catch (IOException e) {
                throw new UncheckedIOException("scan directory failed: " + path, e);
            }
        }

        private void add(Path program) {
            UniqueId id = this.engine.getUniqueId().append("main-java", "java-" + program);
            this.engine.addChild((org.junit.platform.engine.TestDescriptor)new TestDescriptor(id, program));
        }
    }
}

