/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.brahms.maingine;

import de.sormuras.brahms.maingine.Main;
import java.lang.reflect.Method;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;

class MainMethod
extends AbstractTestDescriptor {
    private final Method method;
    private final boolean fork;
    private final String[] arguments;
    private final String[] options;
    private final int expectedExitValue;

    private static String displayName(Main main) {
        String displayName = main.displayName();
        String args = String.join((CharSequence)", ", main.value());
        if (displayName.length() > 0) {
            return displayName.replace("${ARGS}", args);
        }
        return main.displayName().isEmpty() ? "main(" + args + ")" : main.displayName();
    }

    private static boolean isForkEnabled(Main main) {
        try {
            Object defaultFork = Main.class.getDeclaredMethod("java", new Class[0]).getDefaultValue();
            return !defaultFork.equals(main.java());
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("no java() method in @Main class?!", e);
        }
    }

    MainMethod(UniqueId uniqueId, Method method) {
        super(uniqueId, "main()", (TestSource)MethodSource.from((Method)method));
        this.method = method;
        this.fork = false;
        this.arguments = new String[0];
        this.options = new String[0];
        this.expectedExitValue = 0;
    }

    MainMethod(UniqueId uniqueId, Method method, Main main) {
        super(uniqueId, MainMethod.displayName(main), (TestSource)MethodSource.from((Method)method));
        this.method = method;
        this.arguments = main.value();
        this.fork = MainMethod.isForkEnabled(main);
        this.options = main.java().options();
        this.expectedExitValue = main.java().expectedExitValue();
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    Method getMethod() {
        return this.method;
    }

    boolean isFork() {
        return this.fork;
    }

    String[] getArguments() {
        return this.arguments;
    }

    String[] getOptions() {
        return this.options;
    }

    int getExpectedExitValue() {
        return this.expectedExitValue;
    }
}

