/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.Bartholdy;
import de.sormuras.bartholdy.tool.AbstractTool;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;

public class Gradle
extends AbstractTool {
    private final Path home;
    private final String version;
    private final Path executable;

    public static Gradle install(String version, Path tools) {
        String uri = "https://services.gradle.org/distributions/gradle-" + version + "-bin.zip";
        Path home = Bartholdy.install(URI.create(uri), tools);
        return new Gradle(home);
    }

    public Gradle(Path home) {
        this.home = Objects.requireNonNull(home);
        if (!Files.isDirectory(home, new LinkOption[0])) {
            throw new IllegalArgumentException("not a directory: " + home);
        }
        if (!Files.isRegularFile(home.resolve(Path.of("bin", "gradle")), new LinkOption[0])) {
            throw new IllegalArgumentException("`bin/gradle` launch script not found in: " + home);
        }
        this.version = "TODO";
        this.executable = this.getExecutable(home);
    }

    private Path getExecutable(Path home) {
        boolean win = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        String name = "gradle" + (win ? ".bat" : "");
        return Bartholdy.setExecutable(home.resolve("bin").resolve(name));
    }

    @Override
    public Path getHome() {
        return this.home;
    }

    @Override
    protected Path createPathToProgram() {
        return this.executable;
    }

    @Override
    public String getName() {
        return "gradle";
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

