/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.Bartholdy;
import de.sormuras.bartholdy.tool.AbstractTool;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;

public class Ant
extends AbstractTool {
    private final Path home;
    private final String version;
    private final Path executable;

    public static Ant install(String version, Path tools) {
        String host = "https://archive.apache.org/dist/";
        String uri = String.format("%s/ant/binaries/apache-ant-%s-bin.zip", host, version);
        Path home = Bartholdy.install(URI.create(uri), tools);
        return new Ant(home);
    }

    public Ant(Path home) {
        this.home = Objects.requireNonNull(home);
        if (!Files.isDirectory(home, new LinkOption[0])) {
            throw new IllegalArgumentException("not a directory: " + home);
        }
        if (!Files.isRegularFile(home.resolve(Path.of("bin", "ant")), new LinkOption[0])) {
            throw new IllegalArgumentException("`bin/ant` launch script not found in: " + home);
        }
        Path jar = home.resolve(Path.of("lib", "ant.jar"));
        if (!Files.isRegularFile(jar, new LinkOption[0])) {
            throw new IllegalArgumentException("main `lib/ant.jar` not found in: " + home);
        }
        this.version = this.getVersion(jar);
        this.executable = this.getExecutable(home);
    }

    private Path getExecutable(Path home) {
        boolean win = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        String name = "ant" + (win ? ".bat" : "");
        return Bartholdy.setExecutable(home.resolve("bin").resolve(name));
    }

    @Override
    public Path getHome() {
        return this.home;
    }

    @Override
    protected Path createPathToProgram() {
        return this.executable;
    }

    @Override
    public String getName() {
        return "ant";
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    private String getVersion(Path jar) {
        return Bartholdy.read(jar, "/org/apache/tools/ant/version.txt", "", "?");
    }
}

