/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Reflector {
    private final Object options;
    private final UnaryOperator<Stream<Field>> operator;
    private final Consumer<String> consumer;

    public static List<String> reflect(Object options) {
        ArrayList arguments = new ArrayList();
        new Reflector(options, arguments::add).reflect();
        return List.copyOf(arguments);
    }

    public Reflector(Object options, Consumer<String> consumer) {
        this(options, UnaryOperator.identity(), consumer);
    }

    public Reflector(Object options, UnaryOperator<Stream<Field>> operator, Consumer<String> consumer) {
        this.options = options;
        this.operator = operator;
        this.consumer = consumer;
    }

    public Reflector add(Object argument) {
        this.consumer.accept(argument.toString());
        return this;
    }

    Reflector add(Collection<Path> paths) {
        return this.add(paths.stream(), File.pathSeparator);
    }

    Reflector add(Stream<?> stream, String separator) {
        return this.add(stream.map(Object::toString).collect(Collectors.joining(separator)));
    }

    public void reflect() {
        Stream stream = Arrays.stream(this.options.getClass().getDeclaredFields()).filter(field -> !field.isSynthetic()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isPrivate(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers()));
        stream = (Stream)this.operator.apply(stream);
        stream.forEach(this::reflectField);
    }

    private void reflectField(Field field) {
        try {
            this.reflectFieldThrowing(field);
        }
        catch (ReflectiveOperationException e) {
            throw new Error("reflecting field '" + field + "' failed for " + this.options, e);
        }
    }

    private void reflectFieldThrowing(Field field) throws ReflectiveOperationException {
        try {
            this.options.getClass().getDeclaredMethod(field.getName(), Reflector.class).invoke(this.options, this);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Iterator iterator;
            Object head;
            Object value = field.get(this.options);
            if (value == null) {
                return;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                return;
            }
            Optional<Option> optional = Optional.ofNullable(field.getAnnotation(Option.class));
            String optionName = optional.map(Option::value).orElse(this.getOptionName(field.getName()));
            if (field.getType() == Boolean.TYPE) {
                if (field.getBoolean(this.options)) {
                    this.add(optionName);
                }
                return;
            }
            if (!optionName.isEmpty()) {
                this.add(optionName);
            }
            if (value instanceof Collection && (head = (iterator = ((Collection)value).iterator()).next()) instanceof Path) {
                Collection paths = (Collection)value;
                this.add(paths);
                return;
            }
            this.add(value.toString());
            return;
        }
    }

    private String getOptionName(String fieldName) {
        boolean hasUppercase = !fieldName.equals(fieldName.toLowerCase());
        StringBuilder defaultName = new StringBuilder();
        if (hasUppercase) {
            defaultName.append("--");
            fieldName.chars().forEach(i -> {
                if (Character.isUpperCase(i)) {
                    defaultName.append('-');
                    defaultName.append((char)Character.toLowerCase(i));
                } else {
                    defaultName.append((char)i);
                }
            });
        } else {
            defaultName.append('-');
            defaultName.append(fieldName.replace('_', '-'));
        }
        return defaultName.toString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String value();
    }
}

