/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.util;

import de.sormuras.bartholdy.util.CycleDetectedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DirectedAcyclicGraph {
    private final Map<String, Node> nodes = new HashMap<String, Node>();

    public void addEdge(String sourceId, String targetId) {
        if (sourceId.equals(targetId)) {
            throw new CycleDetectedException("Same node: " + sourceId + " == " + targetId);
        }
        int before = this.nodes.size();
        Node source = this.nodes.computeIfAbsent(sourceId, Node::new);
        Node target = this.nodes.computeIfAbsent(targetId, Node::new);
        if (this.nodes.size() == before) {
            if (target.next.contains(source)) {
                throw new CycleDetectedException("Anti-edge: " + source + " <-> " + target);
            }
            this.walk(source, target, List.of());
        }
        source.next.add(target);
    }

    private void walk(Node source, Node root, List<Node> path) {
        for (Node node : root.next) {
            if (node == source) {
                String message = "From " + source + " over " + path + " and " + root + " back to " + source;
                throw new CycleDetectedException(message);
            }
            ArrayList<Node> newPath = new ArrayList<Node>(path);
            newPath.add(root);
            this.walk(source, node, List.copyOf(newPath));
        }
    }

    private static final class Node
    implements Comparable<Node> {
        final String id;
        final Set<Node> next;

        Node(String id) {
            this.id = id;
            this.next = new TreeSet<Node>();
        }

        @Override
        public int compareTo(Node o) {
            return this.id.compareTo(o.id);
        }

        public String toString() {
            return this.id;
        }
    }
}

