/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.Bartholdy;
import de.sormuras.bartholdy.tool.AbstractTool;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public class GradleWrapper
extends AbstractTool {
    private final Path home;

    public GradleWrapper() {
        this(Paths.get(".", new String[0]));
    }

    public GradleWrapper(Path home) {
        this.home = home;
    }

    @Override
    public Path getHome() {
        return this.home;
    }

    @Override
    protected Path createPathToProgram() {
        return this.getHome().resolve(this.getProgram());
    }

    @Override
    public String getName() {
        return "gradle-wrapper";
    }

    @Override
    public String getProgram() {
        boolean win = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        return "gradlew" + (win ? ".bat" : "");
    }

    @Override
    public String getVersion() {
        Path jar = this.getHome().resolve("gradle").resolve("wrapper").resolve("gradle-wrapper.jar");
        String text = Bartholdy.read(jar, "/build-receipt.properties", System.lineSeparator(), "?");
        return Bartholdy.readProperty(text, "versionNumber", "unknown");
    }
}

