/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.Bartholdy;
import de.sormuras.bartholdy.tool.Java;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;

public class GoogleJavaFormat
extends Java {
    private final Path jar;

    public static GoogleJavaFormat install(String version, Path tools) {
        String host = "https://github.com/google/google-java-format/releases/download";
        String name = "google-java-format-" + version;
        String uri = host + "/" + name + "/" + name + "-all-deps.jar";
        Path jar = Bartholdy.download(URI.create(uri), tools);
        return new GoogleJavaFormat(jar);
    }

    public GoogleJavaFormat(Path jar) {
        this.jar = jar;
    }

    @Override
    public String getName() {
        return "google-java-format";
    }

    @Override
    public String getVersion() {
        return this.jar.getFileName().toString();
    }

    @Override
    protected List<String> getToolArguments() {
        return List.of("-jar", this.jar.toString());
    }
}

