/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.Configuration;
import de.sormuras.bartholdy.Result;
import de.sormuras.bartholdy.Tool;
import de.sormuras.bartholdy.jdk.Jdeps;
import de.sormuras.bartholdy.util.CycleDetectedException;
import de.sormuras.bartholdy.util.DirectedAcyclicGraph;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class CyclesDetector
implements Tool {
    private final Path path;
    private static Set<String> IGNORE_TARGET_STARTING_WITH = Set.of("java.", "javax.");

    public CyclesDetector(Path path) {
        this.path = path;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getVersion() {
        return "1.1";
    }

    @Override
    public Result run(Configuration configuration) {
        Result.Builder result = Result.builder();
        try {
            List<String> cycles = this.detectCycles(this.path);
            result.setExitCode(cycles.isEmpty() ? 0 : 1);
            result.setOutput("cycles", cycles);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setExitCode(-1);
        }
        return result.build();
    }

    private List<String> detectCycles(Path path) {
        Configuration.Builder configuration = Configuration.builder();
        try (JarFile jar = new JarFile(path.toFile());){
            if (jar.isMultiRelease()) {
                configuration.addArgument("--multi-release").addArgument(Runtime.version().feature());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Opening jar failed: " + e);
        }
        configuration.addArgument("-verbose:class");
        configuration.addArgument(path);
        Result result = new Jdeps().run(configuration.build());
        if (result.getExitCode() != 0) {
            throw new RuntimeException("Running jdeps failed: " + result);
        }
        List lines = result.getOutputLines("out").stream().filter(line -> line.startsWith("   ")).filter(line -> line.contains("->")).map(String::trim).collect(Collectors.toList());
        ArrayList<Item> items = new ArrayList<Item>();
        for (String line2 : lines) {
            Item item = new Item(line2);
            if (item.sourcePackage.equals(item.targetPackage) || CyclesDetector.ignorePackage(item.targetPackage)) continue;
            items.add(item);
        }
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph();
        ArrayList<String> cycles = new ArrayList<String>();
        for (Item item : items) {
            try {
                graph.addEdge(item.sourcePackage, item.targetPackage);
            }
            catch (CycleDetectedException exception) {
                cycles.add(String.format("Adding edge '%s' failed. %s", item, exception.getMessage()));
            }
        }
        return cycles;
    }

    private static String classNameOf(String raw) {
        raw = raw.trim();
        int indexOfSlash = (raw = raw.replaceAll("\"", "")).indexOf(47);
        if (indexOfSlash >= 0) {
            raw = raw.substring(indexOfSlash + 1);
        }
        return raw;
    }

    private static String packageNameOf(String className) {
        int indexOfLastDot = className.lastIndexOf(46);
        if (indexOfLastDot < 0) {
            return "";
        }
        return className.substring(0, indexOfLastDot);
    }

    private static boolean ignorePackage(String className) {
        for (String prefix : IGNORE_TARGET_STARTING_WITH) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static class Item {
        private final String sourceClass;
        private final String targetClass;
        private final String sourcePackage;
        private final String targetPackage;

        Item(String line) {
            String[] split = line.split("->");
            String target = split[1].trim();
            this.sourceClass = CyclesDetector.classNameOf(split[0].trim());
            this.targetClass = CyclesDetector.classNameOf(target.substring(0, target.indexOf(32)));
            this.sourcePackage = CyclesDetector.packageNameOf(this.sourceClass);
            this.targetPackage = CyclesDetector.packageNameOf(this.targetClass);
        }

        public String toString() {
            return this.sourceClass + " -> " + this.targetClass;
        }
    }
}

