/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.AbstractTool;
import de.sormuras.bartholdy.Bartholdy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;

public class Maven
extends AbstractTool {
    private static final System.Logger LOG = System.getLogger(Maven.class.getName());
    private final Path home;
    private final String version;
    private final Path executable;

    public static Maven install(String version, Path tools) {
        String host = "https://archive.apache.org/dist/maven/maven-3/" + version;
        String uri = String.format("%s/binaries/apache-maven-%s-bin.zip", host, version);
        Path home = Bartholdy.install(URI.create(uri), tools);
        return new Maven(home);
    }

    public Maven(Path home) {
        this.home = Objects.requireNonNull(home);
        if (!Files.isDirectory(home, new LinkOption[0])) {
            throw new IllegalArgumentException("not a directory: " + home);
        }
        if (!Files.isRegularFile(home.resolve(Paths.get("bin", "mvn")), new LinkOption[0])) {
            throw new IllegalArgumentException("`bin/mvn` launch script not found in: " + home);
        }
        this.version = "TODO";
        this.executable = this.getExecutable(home);
    }

    private Path getExecutable(Path home) {
        boolean win = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        String name = "mvn" + (win ? ".cmd" : "");
        return Bartholdy.setExecutable(home.resolve("bin").resolve(name));
    }

    @Override
    public Path getHome() {
        return this.home;
    }

    @Override
    protected Path createPathToProgram() {
        return this.executable;
    }

    @Override
    public String getName() {
        return "maven";
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

