/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface Result {
    public static Builder builder() {
        return new Builder();
    }

    public int getExitCode();

    public Duration getDuration();

    default public String getOutput(String key) {
        return this.getOutput(key, "");
    }

    public String getOutput(String var1, String var2);

    default public List<String> getOutputLines(String key) {
        String value = this.getOutput(key, null);
        if (value == null) {
            return List.of();
        }
        return List.of(value.split("\\R"));
    }

    public static class Builder
    implements Result {
        private int exitCode = Integer.MIN_VALUE;
        private Duration duration = Duration.ZERO;
        private Map<String, String> lines = new HashMap<String, String>();

        public Result build() {
            Objects.requireNonNull(this.duration, "duration must not be null");
            return this;
        }

        public String toString() {
            return "Result{exitCode=" + this.exitCode + ", duration=" + this.duration + ", lines=" + this.lines + "}";
        }

        @Override
        public int getExitCode() {
            return this.exitCode;
        }

        public Builder setExitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        public Builder setDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public String getOutput(String key, String defaultValue) {
            return this.lines.getOrDefault(key, defaultValue);
        }

        public Builder setOutput(String key, String output) {
            this.lines.put(key, output);
            return this;
        }
    }
}

