/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.process;

import de.sormuras.bartholdy.Configuration;
import de.sormuras.bartholdy.Result;
import de.sormuras.bartholdy.Tool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

abstract class AbstractProcessTool
implements Tool {
    AbstractProcessTool() {
    }

    @Override
    public Result run(Configuration configuration) {
        List<String> command = this.createCommand(configuration);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(configuration.getWorkingDirectory().toFile());
        builder.environment().put("JAVA_HOME", AbstractProcessTool.getCurrentJdkHome().toString());
        builder.environment().putAll(configuration.getEnvironment());
        try {
            Process process = builder.start();
            String out = this.read(process.getInputStream());
            String err = this.read(process.getErrorStream());
            int exitCode = process.waitFor();
            process.destroy();
            return Result.builder().setExitCode(exitCode).setOutput("out", out).setOutput("err", err).build();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("run failed", e);
        }
    }

    private List<String> createCommand(Configuration configuration) {
        String program = this.createProgram();
        ArrayList<String> command = new ArrayList<String>();
        command.add(program);
        command.addAll(configuration.getArguments());
        int commandLineLength = String.join((CharSequence)" ", command).length();
        if (commandLineLength < 32000) {
            return command;
        }
        String timestamp = Instant.now().toString().replace("-", "").replace(":", "");
        String prefix = "bartholdy-" + this.getName() + "-arguments-" + timestamp + "-";
        try {
            Path temporaryDirectory = configuration.getTemporaryDirectory();
            Path temporaryFile = Files.createTempFile(temporaryDirectory, prefix, ".txt", new FileAttribute[0]);
            return List.of(program, "@" + Files.write(temporaryFile, configuration.getArguments(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException("creating temporary arguments file failed", e);
        }
    }

    protected abstract String createProgram();

    private String read(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        reader.lines().iterator().forEachRemaining(joiner::add);
        return joiner.toString();
    }

    static Path getCurrentJdkHome() {
        Path executable = ProcessHandle.current().info().command().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow();
        return executable.getParent().getParent().toAbsolutePath();
    }
}

