/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.jdk;

import de.sormuras.bartholdy.Configuration;
import de.sormuras.bartholdy.Result;
import de.sormuras.bartholdy.Tool;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.spi.ToolProvider;

abstract class AbstractJdkTool
implements Tool {
    private final System.Logger logger;
    private final String name = this.getClass().getSimpleName().toLowerCase();

    AbstractJdkTool() {
        this.logger = System.getLogger(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return Runtime.version().toString();
    }

    @Override
    public Result run(Configuration configuration) {
        this.logger.log(System.Logger.Level.DEBUG, "Running...");
        ToolProvider provider = ToolProvider.findFirst(this.getName()).orElseThrow();
        this.logger.log(System.Logger.Level.DEBUG, "Found %s", provider);
        Instant start = Instant.now();
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        String[] args = configuration.getArguments().toArray(new String[0]);
        int code = provider.run(new PrintWriter(out), new PrintWriter(err), args);
        Duration duration = Duration.between(start, Instant.now());
        this.logger.log(System.Logger.Level.DEBUG, "Took %s", duration);
        return Result.builder().setExitCode(code).setDuration(duration).setOutput("out", out.toString()).setOutput("err", err.toString()).build();
    }
}

