/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface Configuration {
    public static Builder builder() {
        return new Builder();
    }

    public static Configuration of(Object ... args) {
        return Configuration.builder().setArguments(args).build();
    }

    public List<String> getArguments();

    public Map<String, String> getEnvironment();

    public Path getTemporaryDirectory();

    public Path getWorkingDirectory();

    default public Builder toBuilder() {
        return Configuration.builder().setArguments(new ArrayList<String>(this.getArguments())).setEnvironment(new HashMap<String, String>(this.getEnvironment()));
    }

    public static class Builder
    implements Configuration {
        private final System.Logger logger = System.getLogger(this.getClass().getCanonicalName());
        private boolean mutable = true;
        private List<String> arguments = new ArrayList<String>();
        private Map<String, String> environment = new HashMap<String, String>();
        private Path temporaryDirectory = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        private Path workingDirectory = Paths.get(".", new String[0]).normalize().toAbsolutePath();

        public Configuration build() {
            this.mutable = false;
            this.arguments = List.copyOf(this.arguments);
            this.environment = Map.copyOf(this.environment);
            return this;
        }

        void checkMutableState() {
            if (this.isMutable()) {
                return;
            }
            throw new IllegalStateException("immutable");
        }

        public boolean isMutable() {
            return this.mutable;
        }

        @Override
        public List<String> getArguments() {
            return this.arguments;
        }

        public Builder addArgument(Object argument) {
            this.checkMutableState();
            this.arguments.add(String.valueOf(Objects.requireNonNull(argument, "argument must not be null")));
            return this;
        }

        public Builder setArguments(List<String> arguments) {
            this.checkMutableState();
            this.arguments = Objects.requireNonNull(arguments, "arguments must not be null");
            return this;
        }

        public Builder setArguments(Object ... arguments) {
            this.checkMutableState();
            this.arguments.clear();
            for (Object argument : arguments) {
                if (argument instanceof Iterable) {
                    this.logger.log(System.Logger.Level.DEBUG, "unrolling iterable argument: " + argument);
                    ((Iterable)argument).forEach(this::addArgument);
                    continue;
                }
                this.addArgument(argument);
            }
            return this;
        }

        @Override
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        Builder setEnvironment(Map<String, String> environment) {
            this.checkMutableState();
            this.environment = environment;
            return this;
        }

        public Builder putEnvironment(String key, String value) {
            this.checkMutableState();
            Objects.requireNonNull(key, "key must not be null");
            Objects.requireNonNull(value, "value must not be null");
            this.environment.put(key, value);
            return this;
        }

        @Override
        public Path getTemporaryDirectory() {
            return this.temporaryDirectory;
        }

        public Builder setTemporaryDirectory(Path temporaryDirectory) {
            this.checkMutableState();
            Objects.requireNonNull(temporaryDirectory, "temporaryDirectory must not be null");
            this.temporaryDirectory = temporaryDirectory;
            return this;
        }

        @Override
        public Path getWorkingDirectory() {
            return this.workingDirectory;
        }

        public Builder setWorkingDirectory(Path workingDirectory) {
            this.checkMutableState();
            Objects.requireNonNull(workingDirectory, "workingDirectory must not be null");
            this.workingDirectory = workingDirectory;
            return this;
        }
    }
}

