/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface Configuration {
    public static Builder builder() {
        return new Builder();
    }

    public static Configuration of(Object ... args) {
        return Configuration.builder().setArguments(args).build();
    }

    public List<String> getArguments();

    public Map<String, String> getEnvironment();

    default public Builder toBuilder() {
        Builder builder = Configuration.builder();
        builder.setArguments(new ArrayList<String>(this.getArguments()));
        return builder;
    }

    public static class Builder
    implements Configuration {
        private final System.Logger logger = System.getLogger(this.getClass().getCanonicalName());
        private boolean mutable = true;
        private List<String> arguments = new ArrayList<String>();
        private Map<String, String> environment = new HashMap<String, String>();

        public Configuration build() {
            this.mutable = false;
            this.arguments = List.copyOf(this.arguments);
            return this;
        }

        void checkMutableState() {
            if (this.isMutable()) {
                return;
            }
            throw new IllegalStateException("immutable");
        }

        public boolean isMutable() {
            return this.mutable;
        }

        @Override
        public List<String> getArguments() {
            return this.arguments;
        }

        public Builder addArgument(Object argument) {
            this.checkMutableState();
            this.arguments.add(String.valueOf(Objects.requireNonNull(argument, "argument must not be null")));
            return this;
        }

        public Builder setArguments(List<String> arguments) {
            this.checkMutableState();
            this.arguments = Objects.requireNonNull(arguments, "arguments must not be null");
            return this;
        }

        public Builder setArguments(Object ... arguments) {
            this.checkMutableState();
            this.arguments.clear();
            for (Object argument : arguments) {
                if (argument instanceof Iterable) {
                    this.logger.log(System.Logger.Level.DEBUG, "unrolling iterable argument: " + argument);
                    ((Iterable)argument).forEach(this::addArgument);
                    continue;
                }
                this.addArgument(argument);
            }
            return this;
        }

        @Override
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        public Builder putEnvironment(String key, String value) {
            this.environment.put(key, value);
            return this;
        }
    }
}

