/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.util;

import de.sormuras.bach.Log;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class Uris {
    private final Log log;
    private final HttpClient http;

    public static Uris ofSystem() {
        return Uris.of(Log.ofSystem());
    }

    public static Uris of(Log log) {
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        return new Uris(log, httpClient);
    }

    public Uris(Log log, HttpClient httpClient) {
        this.log = log;
        this.http = httpClient;
    }

    public HttpResponse<Void> head(URI uRI, int n) throws Exception {
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.noBody();
        Duration duration = Duration.ofSeconds(n);
        HttpRequest httpRequest = HttpRequest.newBuilder(uRI).method("HEAD", bodyPublisher).timeout(duration).build();
        return this.http.send(httpRequest, HttpResponse.BodyHandlers.discarding());
    }

    public Path copy(URI uRI, Path path, CopyOption ... copyOptionArray) throws Exception {
        HttpResponse<Path> httpResponse;
        Object object;
        this.log.debug("Copy %s to %s", uRI, path);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        if ("file".equals(uRI.getScheme())) {
            try {
                return Files.copy(Path.of(uRI), path, copyOptionArray);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("copy file failed:" + uRI, exception);
            }
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder(uRI).GET();
        if (Files.exists(path, new LinkOption[0]) && Files.getFileStore(path).supportsFileAttributeView("user")) {
            try {
                object = (byte[])Files.getAttribute(path, "user:etag", new LinkOption[0]);
                httpResponse = StandardCharsets.UTF_8.decode(ByteBuffer.wrap((byte[])object)).toString();
                builder.setHeader("If-None-Match", (String)((Object)httpResponse));
            }
            catch (Exception exception) {
                this.log.warning("Couldn't get 'user:etag' file attribute: %s", exception);
            }
        }
        object = HttpResponse.BodyHandlers.ofFile(path);
        httpResponse = this.http.send(builder.build(), object);
        if (httpResponse.statusCode() == 200) {
            if (Set.of(copyOptionArray).contains(StandardCopyOption.COPY_ATTRIBUTES)) {
                Object object2;
                Optional<String> optional = httpResponse.headers().firstValue("etag");
                if (optional.isPresent()) {
                    if (Files.getFileStore(path).supportsFileAttributeView("user")) {
                        try {
                            object2 = optional.get();
                            Files.setAttribute(path, "user:etag", StandardCharsets.UTF_8.encode((String)object2), new LinkOption[0]);
                        }
                        catch (Exception exception) {
                            this.log.warning("Couldn't set 'user:etag' file attribute: %s", exception);
                        }
                    }
                } else {
                    this.log.warning("No etag provided in response: %s", httpResponse);
                }
                if (((Optional)(object2 = httpResponse.headers().firstValue("last-modified"))).isPresent()) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                        long l = simpleDateFormat.parse((String)((Optional)object2).get()).getTime();
                        FileTime fileTime = FileTime.fromMillis(l == 0L ? System.currentTimeMillis() : l);
                        Files.setLastModifiedTime(path, fileTime);
                    }
                    catch (Exception exception) {
                        this.log.warning("Couldn't set last modified file attribute: %s", exception);
                    }
                }
            }
            this.log.debug("%s <- %s", path, uRI);
        }
        return path;
    }

    public String read(URI uRI) throws Exception {
        this.log.debug("Read %s", uRI);
        if ("file".equals(uRI.getScheme())) {
            return Files.readString(Path.of(uRI));
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder(uRI).GET();
        return this.http.send(builder.build(), HttpResponse.BodyHandlers.ofString()).body();
    }
}

