/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.util;

import de.sormuras.bach.Call;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.spi.ToolProvider;

public class Tools {
    final Map<String, ToolProvider> map = new TreeMap<String, ToolProvider>();

    public Tools() {
        ServiceLoader.load(ToolProvider.class, ClassLoader.getSystemClassLoader()).stream().map(ServiceLoader.Provider::get).forEach((? super T toolProvider) -> this.map.putIfAbsent(toolProvider.name(), (ToolProvider)toolProvider));
    }

    public ToolProvider get(String string) {
        ToolProvider toolProvider = this.map.get(string);
        if (toolProvider == null) {
            throw new NoSuchElementException("No such tool: " + string);
        }
        return toolProvider;
    }

    public void forEach(Consumer<ToolProvider> consumer) {
        this.map.values().forEach(consumer);
    }

    public int launch(String string, Collection<String> collection) {
        return this.launch(string, collection, true);
    }

    public int launch(String string, Collection<String> collection, boolean bl) {
        ToolProvider toolProvider = this.map.get(string);
        if (toolProvider != null) {
            return toolProvider.run(System.out, System.err, (String[])collection.toArray(String[]::new));
        }
        Call call2 = new Call("Call of tool: " + string, true, new String[0]);
        if (string.equals("mvn")) {
            call2.iff(System.getProperty("os.name").toLowerCase().contains("win"), call -> call.add("cmd", "/C"), call -> call.add("/usr/bin/env", "--"));
        }
        call2.add(string);
        call2.forEach(collection, Call::add);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(call2.toList(false));
            if (bl) {
                processBuilder.inheritIO();
            }
            Process process = processBuilder.start();
            if (!bl) {
                process.getInputStream().transferTo(System.out);
                process.getErrorStream().transferTo(System.err);
            }
            return process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }
}

