/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.util;

import de.sormuras.bach.util.Paths;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Modules {
    private Modules() {
    }

    public static ModuleDescriptor describe(String string) {
        Object object;
        Object object2;
        Matcher matcher = Patterns.NAME.matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Expected Java module source unit, but got: " + string);
        }
        String string2 = matcher.group(1).trim();
        ModuleDescriptor.Builder builder = ModuleDescriptor.newModule(string2);
        Matcher matcher2 = Patterns.MAIN_CLASS.matcher(string);
        if (matcher2.find()) {
            object2 = matcher2.group(1);
            builder.mainClass((String)object2);
        }
        object2 = Patterns.REQUIRES.matcher(string);
        while (((Matcher)object2).find()) {
            object = ((Matcher)object2).group(1);
            Optional.ofNullable(((Matcher)object2).group(2)).ifPresentOrElse(arg_0 -> Modules.lambda$describe$0(builder, (String)object, arg_0), () -> Modules.lambda$describe$1(builder, (String)object));
        }
        object = Patterns.PROVIDES.matcher(string);
        while (((Matcher)object).find()) {
            String string3 = ((Matcher)object).group(1);
            String string4 = ((Matcher)object).group(2);
            builder.provides(string3, List.of(string4.trim().split("\\s*,\\s*")));
        }
        return builder.build();
    }

    public static String origin(Object object) {
        Module module = object.getClass().getModule();
        if (module.isNamed()) {
            return module.getDescriptor().toNameAndVersion();
        }
        try {
            URI uRI = object.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            return Path.of(uRI).getFileName().toString();
        }
        catch (NullPointerException | URISyntaxException exception) {
            return module.toString();
        }
    }

    private static /* synthetic */ void lambda$describe$1(ModuleDescriptor.Builder builder, String string) {
        builder.requires(string);
    }

    private static /* synthetic */ void lambda$describe$0(ModuleDescriptor.Builder builder, String string, String string2) {
        builder.requires(Set.of(), string, ModuleDescriptor.Version.parse(string2));
    }

    private static interface Patterns {
        public static final Pattern MAIN_CLASS = Pattern.compile("//\\s*(?:--main-class)\\s+([\\w.]+)");
        public static final Pattern NAME = Pattern.compile("(?:module)\\s+([\\w.]+)(?:\\s*/\\*.*\\*/\\s*)?\\s*\\{");
        public static final Pattern REQUIRES = Pattern.compile("(?:requires)(?:\\s+[\\w.]+)?\\s+([\\w.]+)(?:\\s*/\\*\\s*([\\w.\\-+]+)\\s*\\*/\\s*)?\\s*;");
        public static final Pattern PROVIDES = Pattern.compile("(?:provides)\\s+([\\w.]+)\\s+with\\s+([\\w.,\\s]+)\\s*;");
    }

    public static class Survey {
        final Set<String> declaredModules;
        final Map<String, Set<ModuleDescriptor.Version>> requiresMap;

        public static Survey of(ModuleFinder moduleFinder) {
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>();
            Stream<ModuleDescriptor.Requires> stream = moduleFinder.findAll().stream().map(ModuleReference::descriptor).peek(moduleDescriptor -> treeSet.add(moduleDescriptor.name())).map(ModuleDescriptor::requires).flatMap(Collection::stream).filter(requires -> !requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC));
            Survey.merge(treeMap, stream);
            return new Survey(treeSet, treeMap);
        }

        public static Survey of(String ... stringArray) {
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>();
            for (String string : stringArray) {
                ModuleDescriptor moduleDescriptor = Modules.describe(string);
                treeSet.add(moduleDescriptor.name());
                Survey.merge(treeMap, moduleDescriptor.requires().stream());
            }
            return new Survey(treeSet, treeMap);
        }

        static void merge(Map<String, Set<ModuleDescriptor.Version>> map, Stream<ModuleDescriptor.Requires> stream) {
            stream.filter(requires -> !requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.MANDATED)).forEach(requires -> map.merge(requires.name(), requires.compiledVersion().map(Set::of).orElse(Set.of()), Survey::concat));
        }

        static <E extends Comparable<E>> Set<E> concat(Set<E> set, Set<E> set2) {
            return Stream.concat(set.stream(), set2.stream()).collect(Collectors.toCollection(TreeSet::new));
        }

        public static Survey of(Collection<Path> collection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Path path : collection) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    path = path.resolve("module-info.java");
                }
                arrayList.add(Paths.readString(path));
            }
            return Survey.of(arrayList.toArray(new String[0]));
        }

        Survey(Set<String> set, Map<String, Set<ModuleDescriptor.Version>> map) {
            this.declaredModules = set;
            this.requiresMap = map;
        }

        public Set<String> declaredModules() {
            return this.declaredModules;
        }

        public Set<String> requiredModules() {
            return this.requiresMap.keySet();
        }

        public void putAllRequiresTo(Map<String, Set<ModuleDescriptor.Version>> map) {
            map.putAll(this.requiresMap);
        }

        public Optional<ModuleDescriptor.Version> requiredVersion(String string) {
            Set<ModuleDescriptor.Version> set = this.requiresMap.get(string);
            if (set == null) {
                throw new UnmappedModuleException(string);
            }
            if (set.size() > 1) {
                throw new IllegalStateException("Multiple versions: " + string + " -> " + set);
            }
            return set.stream().findFirst();
        }
    }

    public static class UnmappedModuleException
    extends RuntimeException {
        private static final long serialVersionUID = 6985648789039587478L;

        public UnmappedModuleException(String string) {
            super("Module " + string + " is not mapped");
        }
    }
}

