/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.util;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Call;
import de.sormuras.bach.project.Library;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Template;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.util.Modules;
import de.sormuras.bach.util.Paths;
import de.sormuras.bach.util.Uris;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class Maven {
    private static Map<String, String> map(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : properties.stringPropertyNames()) {
            hashMap.put(string, properties.getProperty(string));
        }
        return Map.copyOf(hashMap);
    }

    private static String substring(String string, String string2, String string3) {
        int n = string.indexOf(string2) + string2.length();
        int n2 = string.indexOf(string3, n);
        return string.substring(n, n2).trim();
    }

    public static class Scribe {
        final Bach bach;
        final Project project;

        public Scribe(Bach bach) {
            this.bach = bach;
            this.project = bach.getProject();
        }

        public void generateMavenPoms(Iterable<Unit> iterable) throws Exception {
            Path path = this.project.folder().src("maven-pom-template.xml");
            for (Unit unit : iterable) {
                Object object;
                Object object2;
                Path path2 = unit.mavenPom().orElse(path);
                if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
                String string = Paths.readString(path2);
                String string2 = this.group(string);
                Map<Template.Placeholder, String> map = Map.of(Template.Placeholder.GROUP, string2, Template.Placeholder.MODULE, unit.name(), Template.Placeholder.VERSION, this.project.version(unit).toString());
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Object object3 = string.lines().collect(Collectors.toList()).iterator();
                while (object3.hasNext()) {
                    object2 = "<!--${DEPENDENCIES}-->";
                    object = (String)object3.next();
                    if (((String)object2).equals(((String)object).strip())) {
                        String string3 = ((String)object).substring(0, ((String)object).indexOf((String)object2));
                        for (ModuleDescriptor.Requires requires : unit.descriptor().requires()) {
                            Unit unit2 = this.project.unit(unit.realm().name(), requires.name()).orElse(null);
                            if (unit2 == null) continue;
                            arrayList.add(string3 + "<dependency>");
                            arrayList.add(string3 + "  <groupId>" + string2 + "</groupId>");
                            arrayList.add(string3 + "  <artifactId>" + unit2.name() + "</artifactId>");
                            arrayList.add(string3 + "  <version>" + this.project.version(unit2) + "</version>");
                            arrayList.add(string3 + "</dependency>");
                        }
                        continue;
                    }
                    arrayList.add(Template.replace((String)object, map));
                }
                object3 = this.pom(unit);
                Files.createDirectories(object3.getParent(), new FileAttribute[0]);
                Files.write((Path)object3, arrayList, new OpenOption[0]);
                this.bach.getLog().debug("Generated pom: %s", object3);
                object = new Call("Maven Command Properties", new String[0]).add("-Dfile=" + this.project.modularJar(unit)).add("-DpomFile=" + (Path)object3).add("-Dsources=" + this.project.sourcesJar(unit)).add("-Djavadoc=" + this.project.javadocJar(unit.realm()));
                object2 = this.project.folder().deploy(unit, "maven-cli-arguments.txt");
                Files.write((Path)object2, ((Call)object).toList(false), new OpenOption[0]);
            }
        }

        String group(String string) {
            String string2 = this.project.group();
            if (string2 != null) {
                return string2;
            }
            try {
                return Maven.substring(string, "<groupId>", "<");
            }
            catch (Exception exception) {
                this.bach.getLog().warning("Guessing Maven Group Id failed: %s", exception);
                throw new AssertionError((Object)"Maven GroupId not defined!");
            }
        }

        Path pom(Unit unit) {
            return this.project.folder().deploy(unit, "pom.xml");
        }
    }

    public static class Central {
        private final Map<String, String> mavens;
        private final Map<String, String> versions;

        public Central(Uris uris) throws Exception {
            Path path = Path.of(System.getProperty("user.home"), new String[0]);
            Path path2 = Files.createDirectories(path.resolve(".bach/modules"), new FileAttribute[0]);
            Path path3 = uris.copy(URI.create("https://github.com/sormuras/modules/raw/master/module-maven.properties"), path2.resolve("module-maven.properties"), StandardCopyOption.COPY_ATTRIBUTES);
            this.mavens = Maven.map(Paths.load(new Properties(), path3));
            Path path4 = uris.copy(URI.create("https://github.com/sormuras/modules/raw/master/module-version.properties"), path2.resolve("module-version.properties"), StandardCopyOption.COPY_ATTRIBUTES);
            this.versions = Maven.map(Paths.load(new Properties(), path4));
        }

        public Library.Link link(String string) {
            String string2 = this.mavens.get(string);
            if (string2 == null) {
                throw new Modules.UnmappedModuleException(string);
            }
            int n = string2.indexOf(58);
            if (n < 0) {
                throw new AssertionError((Object)("Expected group:artifact, but got: " + string2));
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            String string5 = this.versions.get(string);
            if (string5 == null) {
                throw new Modules.UnmappedModuleException(string);
            }
            return Library.Link.central(string3, string4, string5);
        }
    }
}

