/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Call;
import de.sormuras.bach.Log;
import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Unit;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.spi.ToolProvider;
import java.util.stream.StreamSupport;

class Tester {
    private final Bach bach;
    private final Realm realm;
    private final Log log;
    private final Folder folder;

    Tester(Bach bach, Realm realm) {
        this.bach = bach;
        this.realm = realm;
        this.log = bach.getLog();
        this.folder = bach.getProject().folder();
    }

    void test(Iterable<Unit> iterable) {
        this.log.debug("Launching all tests in realm " + this.realm, new Object[0]);
        for (Unit unit : iterable) {
            this.log.debug("Testing %s...", unit);
            this.test(unit);
        }
    }

    private void test(Unit unit) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(this.bach.getProject().modularJar(unit));
        arrayList.addAll(this.realm.modulePaths());
        arrayList.add(this.folder.modules(this.realm.name(), new String[0]));
        ModuleLayer moduleLayer = this.layer(arrayList, unit.name());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.runAll(moduleLayer, "test(" + unit.name() + ")", new String[0]));
        stringBuilder.append(this.run(moduleLayer, "junit", "--select-module", unit.name(), "--reports-dir", this.folder.realm(this.realm.name(), "junit-reports", unit.name()).toString()));
        if (stringBuilder.toString().replace('0', ' ').isBlank()) {
            return;
        }
        throw new AssertionError((Object)("Test run failed! // " + stringBuilder));
    }

    private ModuleLayer layer(List<Path> list, String string) {
        ModuleFinder moduleFinder = ModuleFinder.of((Path[])list.toArray(Path[]::new));
        List<String> list2 = List.of(string);
        if (this.bach.isVerbose()) {
            this.log.debug("Module path:", new Object[0]);
            for (Path object2 : list) {
                this.log.debug("  -> %s", object2);
            }
            this.log.debug("Finder finds module(s):", new Object[0]);
            moduleFinder.findAll().stream().sorted(Comparator.comparing(ModuleReference::descriptor)).forEach(moduleReference -> this.log.debug("  -> %s", moduleReference));
            this.log.debug("Root module(s):", new Object[0]);
            for (String string2 : list2) {
                this.log.debug("  -> %s", string2);
            }
        }
        Iterator<String> iterator = ModuleLayer.boot();
        Configuration configuration = ((ModuleLayer)((Object)iterator)).configuration().resolveAndBind(moduleFinder, ModuleFinder.of(new Path[0]), list2);
        ClassLoader classLoader = ClassLoader.getPlatformClassLoader();
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, List.of(iterator), classLoader);
        return controller.layer();
    }

    private int run(ModuleLayer moduleLayer, String string, String ... stringArray) {
        ServiceLoader<ToolProvider> serviceLoader = ServiceLoader.load(moduleLayer, ToolProvider.class);
        Optional<ToolProvider> optional = StreamSupport.stream(serviceLoader.spliterator(), false).filter(toolProvider -> toolProvider.name().equals(string)).findFirst();
        if (optional.isEmpty()) {
            return 1;
        }
        return this.run(optional.get(), stringArray);
    }

    private int runAll(ModuleLayer moduleLayer, String string, String ... stringArray) {
        ServiceLoader<ToolProvider> serviceLoader = ServiceLoader.load(moduleLayer, ToolProvider.class);
        return StreamSupport.stream(serviceLoader.spliterator(), false).filter(toolProvider -> toolProvider.name().equals(string)).mapToInt(toolProvider -> Math.abs(this.run((ToolProvider)toolProvider, stringArray))).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(ToolProvider toolProvider, String ... stringArray) {
        ClassLoader classLoader = toolProvider.getClass().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            for (ClassLoader classLoader3 = classLoader; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
                classLoader3.setDefaultAssertionStatus(true);
            }
            int n = this.bach.run(toolProvider, new Call(toolProvider.name(), stringArray));
            return n;
        }
        finally {
            thread.setContextClassLoader(classLoader2);
        }
    }
}

