/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Log;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.util.Paths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class SummaryTask
implements Task {
    @Override
    public void execute(Bach bach) throws Exception {
        Object object;
        Object object2;
        Log log = bach.getLog();
        Project project = bach.getProject();
        List<Realm> list = project.structure().realms();
        if (list.isEmpty()) {
            log.warning("No realm configured in project: %s", project);
        }
        log.info("Tool runs", new Object[0]);
        log.info("Duration Tool", new Object[0]);
        for (Log.Run object3 : log.getRuns()) {
            object2 = object3.args().length == 0 ? "" : " " + String.join((CharSequence)" ", object3.args());
            object = ((String)object2).length() <= 111 ? object2 : ((String)object2).substring(0, 108) + "...";
            log.info("  %6d %s%s", object3.duration().toMillis(), object3.name(), object);
        }
        for (Realm realm : list) {
            log.info("Modules of %s realm", realm.name());
            object2 = project.folder().modules(realm.name(), new String[0]);
            if (Files.notExists((Path)object2, new LinkOption[0])) {
                if (project.units(realm).isEmpty()) continue;
                log.warning("Modules folder not found: %s", object2);
                continue;
            }
            object = Paths.list((Path)object2, "*.jar");
            log.info("%d jar(s) found in: %s", object.size(), object2.toUri());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                log.info("%,11d %s", Files.size(path), path.getFileName());
            }
        }
        Duration duration = Duration.between(log.getInstant(), Instant.now());
        log.info("Build %d took millis.", duration.toMillis());
        this.writeSummaryLog(log, project.folder());
        this.writeSummaryMarkdown(log, project.folder());
    }

    private String toString(Log.Entry entry) {
        return String.format("%s|%s|%s", new Object[]{entry.instant(), entry.level(), entry.message()});
    }

    private void writeSummaryLog(Log log, Folder folder) throws Exception {
        List<Log.Entry> list = log.getEntries();
        String string = log.getInstant().toString().replace(":", "-");
        Path path = folder.log("summary-" + string + ".log");
        Files.createDirectories(folder.log(), new FileAttribute[0]);
        Files.write(path, (Iterable<? extends CharSequence>)list.stream().map(this::toString).collect(Collectors.toList()), new OpenOption[0]);
        Files.copy(path, folder.out("summary.log"), StandardCopyOption.REPLACE_EXISTING);
    }

    private void writeSummaryMarkdown(Log log, Folder folder) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("# Summary");
        arrayList.add("");
        arrayList.add("## Tools");
        arrayList.add("");
        arrayList.add("| Task | Duration (millis) | Exit Code | Tool Name | Arguments |");
        arrayList.add("| ---: | ----------------: | --------: | :-------- | --------- |");
        for (Log.Run object : log.getRuns()) {
            String string = object.task();
            long l = object.duration().toMillis();
            int n = object.code();
            String string2 = object.name();
            String string3 = object.args().length == 0 ? "" : "`" + String.join((CharSequence)" ", object.args()) + "`";
            arrayList.add(String.format("| %s | %d |  %d | `%s` | %s |", string, l, n, string2, string3));
        }
        arrayList.add("");
        arrayList.add("## Messages logged at INFO and more severe levels");
        arrayList.add("");
        for (Log.Entry entry : log.getEntries()) {
            if (entry.level().getSeverity() < System.Logger.Level.INFO.getSeverity()) continue;
            arrayList.add("- " + entry.message());
        }
        arrayList.add("");
        arrayList.add("## All log entries");
        arrayList.add("");
        for (Log.Entry entry : log.getEntries()) {
            arrayList.add("- " + entry.message());
        }
        arrayList.add("");
        Files.write(folder.out("summary.md"), arrayList, new OpenOption[0]);
    }
}

