/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Call;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Unit;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StartTask
implements Task {
    private final Iterable<String> arguments;

    public StartTask(Iterable<String> iterable) {
        this.arguments = iterable;
    }

    @Override
    public void execute(Bach bach) throws Exception {
        Project project = bach.getProject();
        List<Unit> list = project.structure().units();
        List list2 = list.stream().filter(Unit::isMainClassPresent).collect(Collectors.toList());
        if (list2.isEmpty()) {
            bach.getLog().warning("No main class found.", new Object[0]);
            return;
        }
        if (list2.size() > 1) {
            bach.getLog().warning("Multiple units with main-class found: %s", list2);
            return;
        }
        Unit unit = (Unit)list2.get(0);
        Realm realm = unit.realm();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(project.folder().modules(realm.name(), new String[0]));
        arrayList.addAll(realm.modulePaths());
        Call call = new Call(Path.of(System.getProperty("java.home"), "bin", "java").toString(), new String[0]);
        call.add("--module-path", arrayList);
        call.add("--module", unit.name());
        call.forEach(this.arguments, Call::add);
        int n = bach.start(call.toList(true));
        if (n != 0) {
            throw new Error("Non-zero exit code: " + n + " // " + call);
        }
    }
}

