/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Log;
import de.sormuras.bach.project.Library;
import de.sormuras.bach.project.Template;
import de.sormuras.bach.util.Maven;
import de.sormuras.bach.util.Uris;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

class Resolver {
    private final Log log;
    private final Library library;
    private final Uris uris;
    private final AtomicReference<Maven.Central> central = new AtomicReference<Object>(null);

    Resolver(Log log, Library library) {
        this.log = log;
        this.library = library;
        this.uris = Uris.of(log);
    }

    public void resolveLibraryRequires(Path path) throws Exception {
        for (Library.Requires requires : this.library.requires()) {
            this.resolve(path, requires.name(), requires.version());
        }
    }

    public void resolveModules(Path path, Map<String, Set<ModuleDescriptor.Version>> map) throws Exception {
        for (Map.Entry<String, Set<ModuleDescriptor.Version>> entry : map.entrySet()) {
            String string = entry.getKey();
            ModuleDescriptor.Version version = Resolver.singleton((Collection)entry.getValue()).orElse(null);
            this.resolve(path, string, version);
        }
    }

    private void resolve(Path path, String string, ModuleDescriptor.Version version) throws Exception {
        Library.Link link = this.lookup(string, version);
        String string2 = link.reference();
        Path path2 = path.resolve(string + "-" + link.version() + ".jar");
        this.uris.copy(URI.create(string2), path2, StandardCopyOption.COPY_ATTRIBUTES);
    }

    Library.Link lookup(String string) {
        Library.Link link = this.library.links().get(string);
        if (link != null) {
            return link;
        }
        return this.central().link(string);
    }

    Library.Link lookup(String string, ModuleDescriptor.Version version) {
        Library.Link link = this.lookup(string);
        return Resolver.replace(link, version != null ? version : link.version());
    }

    private Maven.Central central() {
        Maven.Central central = this.central.get();
        if (central != null) {
            return central;
        }
        try {
            this.log.info("Create Maven Central link factory", new Object[0]);
            Maven.Central central2 = new Maven.Central(this.uris);
            return this.central.compareAndSet(null, central2) ? central2 : this.central.get();
        }
        catch (Exception exception) {
            throw new AssertionError("Create Central failed", exception);
        }
    }

    static Library.Link replace(Library.Link link, ModuleDescriptor.Version version) {
        String string = link.reference();
        if (string.indexOf(36) < 0) {
            return link;
        }
        Map<Template.Placeholder, String> map = Map.of(Template.Placeholder.JAVAFX_PLATFORM, Template.Placeholder.JAVAFX_PLATFORM.getDefault(), Template.Placeholder.LWJGL_NATIVES, Template.Placeholder.LWJGL_NATIVES.getDefault(), Template.Placeholder.VERSION, version.toString());
        return new Library.Link(Template.replace(string, map), version);
    }

    private static <T> Optional<T> singleton(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        if (collection.size() != 1) {
            throw new IllegalStateException("Too many elements: " + collection);
        }
        return Optional.of(collection.iterator().next());
    }
}

