/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Log;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Library;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.task.Resolver;
import de.sormuras.bach.util.Modules;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ResolveTask
implements Task {
    @Override
    public void execute(Bach bach) throws Exception {
        Project project = bach.getProject();
        Log log = bach.getLog();
        Path path = project.folder().lib();
        Library library = project.structure().library();
        Resolver resolver = new Resolver(log, library);
        resolver.resolveLibraryRequires(path);
        Modules.Survey survey = Modules.Survey.of(ModuleFinder.ofSystem());
        Map<String, Set<ModuleDescriptor.Version>> map = this.findMissingModules(bach, survey);
        if (map.isEmpty()) {
            log.debug("All required modules are locatable.", new Object[0]);
            return;
        }
        log.info("Resolving missing modules...", new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = library.modifiers().contains((Object)Library.Modifier.RESOLVE_RECURSIVELY);
        do {
            TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
            resolver.resolveModules(path, map);
            arrayList.addAll(map.keySet());
            map.clear();
            Modules.Survey survey2 = Modules.Survey.of(ModuleFinder.of(path));
            survey2.putAllRequiresTo(map);
            survey2.declaredModules().forEach(map::remove);
            survey.declaredModules().forEach(map::remove);
            treeSet.retainAll(map.keySet());
            if (treeSet.isEmpty()) continue;
            throw new IllegalStateException("Unresolved module(s): " + treeSet);
        } while (bl && !map.isEmpty());
        log.info("Resolved %d missing module(s): %s", arrayList.size(), arrayList);
    }

    Map<String, Set<ModuleDescriptor.Version>> findMissingModules(Bach bach, Modules.Survey survey) {
        Project project = bach.getProject();
        Log log = bach.getLog();
        Path path = project.folder().lib();
        Library library = project.structure().library();
        List<Path> list = project.structure().units().stream().map(Unit::info).collect(Collectors.toList());
        Modules.Survey survey2 = Modules.Survey.of(list);
        Modules.Survey survey3 = Modules.Survey.of(ModuleFinder.of(path));
        log.debug("Project modules survey of %s unit(s) -> %s", list.size(), list);
        log.debug("  declared -> " + survey2.declaredModules(), new Object[0]);
        log.debug("  requires -> " + survey2.requiredModules(), new Object[0]);
        log.debug("Library modules survey of -> %s", path.toUri());
        log.debug("  declared -> " + survey3.declaredModules(), new Object[0]);
        log.debug("  requires -> " + survey3.requiredModules(), new Object[0]);
        log.debug("System contains %d modules.", survey.declaredModules().size());
        TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>();
        survey2.putAllRequiresTo(treeMap);
        survey3.putAllRequiresTo(treeMap);
        if (library.modifiers().contains((Object)Library.Modifier.ADD_MISSING_JUNIT_TEST_ENGINES)) {
            Library.addJUnitTestEngines(treeMap);
        }
        if (library.modifiers().contains((Object)Library.Modifier.ADD_MISSING_JUNIT_PLATFORM_CONSOLE)) {
            Library.addJUnitPlatformConsole(treeMap);
        }
        survey2.declaredModules().forEach(treeMap::remove);
        survey3.declaredModules().forEach(treeMap::remove);
        survey.declaredModules().forEach(treeMap::remove);
        return treeMap;
    }
}

