/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Call;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.util.Paths;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LinkTask
implements Task {
    @Override
    public void execute(Bach bach) {
        Project project = bach.getProject();
        List<Unit> list = project.structure().units();
        Unit unit = list.stream().filter(Unit::isLinkable).findFirst().orElse(null);
        if (unit == null) {
            bach.getLog().debug("No linkable module unit found in: %s", list);
            return;
        }
        Realm realm = unit.realm();
        Path path = Paths.deleteIfExists(project.folder().realm(realm.name(), "image"));
        Stream<String> stream = project.units(realm).stream().map(Unit::name);
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(project.folder().modules(realm.name(), new String[0]));
        arrayList.addAll(realm.modulePaths());
        Call call2 = new Call("jlink", new String[0]).add("--output", path).add("--add-modules", stream.collect(Collectors.joining(","))).add("--launcher", project.name() + "=" + unit.name()).add("--module-path", arrayList).add("--compress", "2").add("--no-header-files").add("--strip-debug").iff(bach.isVerbose(), call -> call.add("--verbose"));
        bach.execute(call2);
    }
}

