/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Call;
import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Source;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.util.Paths;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class Jigsaw {
    private final Bach bach;
    private final Realm realm;
    private final Folder folder;
    private final Path classesDirectory;
    private final Path javadocDirectory;

    Jigsaw(Bach bach, Realm realm) {
        this.bach = bach;
        this.realm = realm;
        this.folder = bach.getProject().folder();
        this.classesDirectory = this.folder.realm(realm.name(), new String[0]).resolve("classes/jigsaw");
        this.javadocDirectory = this.folder.realm(realm.name(), new String[0]).resolve("javadoc/jigsaw");
    }

    void compile(List<Unit> list) {
        Object object;
        List<String> list2;
        String string;
        String string2 = list.stream().map(Unit::name).collect(Collectors.joining(","));
        ArrayList arrayList = new ArrayList();
        String string3 = list.stream().filter(Predicate.not(Unit::isMultiRelease)).peek(arrayList::add).map(Unit::name).collect(Collectors.joining(","));
        ArrayList<Path> arrayList2 = new ArrayList<Path>();
        arrayList2.add(this.folder.modules(this.realm.name(), new String[0]));
        arrayList2.addAll(this.realm.modulePaths());
        if (!string3.isBlank()) {
            this.bach.getLog().info("Compiling %d module(s)...", arrayList.size());
            this.bach.execute(new Call("javac", new String[0]).add("-d", this.classesDirectory).iff(this.realm.release(), (call, n) -> call.add("--release", n)).iff(this.realm.isPreviewRealm(), call -> call.add("--enable-preview")).add("--module", string3).add("--module-source-path", this.realm.moduleSourcePath()).forEach(list, this::patchModule).add("--module-path", Paths.filterExisting(arrayList2)).add("--module-version", this.bach.getProject().version()).forEach(this.realm.argumentsFor("javac"), Call::add).add("--class-path", ""));
        }
        String string4 = string = (list2 = this.realm.argumentsFor("javadoc --module")).isEmpty() || list2.equals(List.of("ALL-REALM")) ? string2 : String.join((CharSequence)",", list2);
        if (this.realm.isMainRealm()) {
            object = list.stream().map(unit -> Paths.star(unit.info(), unit.name())).distinct().collect(Collectors.joining(File.pathSeparator));
            Call object2 = new Call("javadoc", new String[0]).forEach(this.realm.argumentsFor("javadoc"), Call::add).add("-d", Paths.createDirectories(this.javadocDirectory)).add("--module", string).iff(!this.bach.isVerbose(), call -> call.add("-quiet")).add("--module-path", Paths.filterExisting(arrayList2)).add("--module-source-path", object);
            for (Unit unit2 : list) {
                if (!unit2.isMultiRelease()) continue;
                Source source = unit2.sources().get(0);
                if (unit2.info().startsWith(source.path())) continue;
                object2.add("--patch-module", unit2.name() + "=" + source.path());
            }
            this.bach.execute(object2);
            Path path = this.bach.getProject().javadocJar(this.realm);
            Paths.createDirectories(path.getParent());
            this.bach.execute(new Call("jar", new String[0]).add("--create").add("--file", path).iff(this.bach.isVerbose(), call -> call.add("--verbose")).add("--no-manifest").add("-C", this.javadocDirectory).add("."));
        }
        Paths.createDirectories(this.folder.modules(this.realm.name(), new String[0]));
        for (Unit unit3 : list) {
            if (unit3.isMultiRelease()) continue;
            this.jarModule(unit3);
            if (!this.realm.isMainRealm()) continue;
            this.jarSources(unit3);
        }
        if (this.bach.isVerbose()) {
            object = new Call("jdeps", new String[0]).add("--module-path", Paths.filterExisting(arrayList2)).add("--multi-release", "BASE");
            int n2 = this.bach.run(((Call)object).clone().add("-summary").add("--dot-output", this.folder.realm(this.realm.name(), "dot")).add("--add-modules", string2));
            if (n2 != 0) {
                this.bach.getLog().warning("jdeps reported: " + n2, new Object[0]);
            } else {
                this.bach.execute(((Call)object).clone().add("--check", string));
            }
        }
    }

    private void patchModule(Call call, Unit unit) {
        if (unit.patches().isEmpty()) {
            return;
        }
        call.add("--patch-module", unit.name() + "=" + Paths.join(unit.patches()));
    }

    private void jarModule(Unit unit) {
        Path path2 = this.bach.getProject().modularJar(unit);
        List<Path> list = Paths.filterExisting(unit.resources());
        this.bach.execute(new Call("jar", new String[0]).add("--create").add("--file", path2).iff(this.bach.isVerbose(), call -> call.add("--verbose")).iff(unit.descriptor().version(), (call, version) -> call.add("--module-version", version.toString())).iff(unit.descriptor().mainClass(), (call, string) -> call.add("--main-class", string)).add("-C", this.classesDirectory.resolve(unit.name())).add(".").forEach(list, (call, path) -> call.add("-C", path).add(".")));
        if (this.bach.isVerbose()) {
            this.bach.execute("jar", "--describe-module", "--file", path2);
        }
    }

    private void jarSources(Unit unit) {
        Path path2 = this.bach.getProject().sourcesJar(unit);
        Paths.createDirectories(path2.getParent());
        List<Path> list = Paths.filterExisting(unit.sources(Source::path));
        List<Path> list2 = Paths.filterExisting(unit.resources());
        this.bach.execute(new Call("jar", new String[0]).add("--create").add("--file", path2).iff(this.bach.isVerbose(), call -> call.add("--verbose")).add("--no-manifest").forEach(list, (call, path) -> call.add("-C", path).add(".")).forEach(list2, (call, path) -> call.add("-C", path).add(".")));
    }
}

