/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Log;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.task.Hydra;
import de.sormuras.bach.task.Jigsaw;
import de.sormuras.bach.util.Maven;
import de.sormuras.bach.util.Paths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class CompileTask
implements Task {
    @Override
    public void execute(Bach bach) throws Exception {
        Log log = bach.getLog();
        Project project = bach.getProject();
        Path path = project.folder().lib();
        if (Files.isDirectory(path, new LinkOption[0])) {
            log.debug("Library %s contains", path.toAbsolutePath());
            Paths.walk(path, string -> log.debug("  %s", string));
        }
        for (Realm realm : project.structure().realms()) {
            List<Unit> list = project.units(realm);
            if (list.isEmpty()) continue;
            log.debug("Compiling %d %s unit(s): %s", list.size(), realm.name(), list);
            new Hydra(bach, realm).compile(list);
            new Jigsaw(bach, realm).compile(list);
            if (!realm.isMainRealm()) continue;
            Maven.Scribe scribe = new Maven.Scribe(bach);
            scribe.generateMavenPoms(list);
        }
    }
}

