/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import java.nio.file.Path;
import java.util.OptionalInt;
import java.util.Set;

public class Source {
    private final Path path;
    private final int release;
    private final Set<Modifier> modifiers;

    public static Source of(Path path, Modifier ... modifierArray) {
        return new Source(path, 0, Set.of(modifierArray));
    }

    public static Source of(Path path, int n) {
        return new Source(path, n, Set.of(Modifier.VERSIONED));
    }

    public Source(Path path, int n, Set<Modifier> set) {
        this.path = path;
        this.release = n;
        this.modifiers = Set.copyOf(set);
    }

    public Path path() {
        return this.path;
    }

    public int release() {
        return this.release;
    }

    public Set<Modifier> modifiers() {
        return this.modifiers;
    }

    public boolean isTargeted() {
        return this.release != 0;
    }

    public OptionalInt target() {
        return this.isTargeted() ? OptionalInt.of(this.release) : OptionalInt.empty();
    }

    public boolean isVersioned() {
        return this.modifiers.contains((Object)Modifier.VERSIONED);
    }

    public String toString() {
        return String.format("Source{path=%s, release=%d, modifiers=%s", this.path, this.release, this.modifiers);
    }

    public static enum Modifier {
        VERSIONED;

    }
}

