/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import de.sormuras.bach.util.Paths;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class Realm {
    public static final String ALL_MODULES = "ALL-REALM";
    public static final String JAVADOC_MODULES_OPTION = "javadoc --module";
    private final String name;
    private final Set<Modifier> modifiers;
    private final int release;
    private final List<Path> sourcePaths;
    private final List<Path> modulePaths;
    private final Map<String, List<String>> argumentsFor;

    public static Map<String, List<String>> defaultArgumentsFor(String string) {
        if (!"test".equals(string)) {
            return Map.of("javac", List.of("-encoding", "UTF-8", "-parameters", "-Werror", "-Xlint"), "javadoc", List.of("-encoding", "UTF-8", "-locale", "en", "-Xdoclint:-missing"), JAVADOC_MODULES_OPTION, List.of(ALL_MODULES));
        }
        return Map.of("javac", List.of("-encoding", "UTF-8", "-parameters", "-Werror", "-Xlint:-preview"), "junit", List.of());
    }

    public Realm(String string, Set<Modifier> set, int n, List<Path> list, List<Path> list2, Map<String, List<String>> map) {
        this.name = string;
        this.modifiers = set.isEmpty() ? Set.of() : EnumSet.copyOf(set);
        this.release = n;
        this.sourcePaths = List.copyOf(list);
        this.modulePaths = List.copyOf(list2);
        this.argumentsFor = Map.copyOf(map);
    }

    public String name() {
        return this.name;
    }

    public Set<Modifier> modifiers() {
        return this.modifiers;
    }

    public Optional<Integer> release() {
        return this.release == 0 ? Optional.empty() : Optional.of(this.release);
    }

    public boolean isMainRealm() {
        return this.modifiers.contains((Object)Modifier.MAIN);
    }

    public boolean isTestRealm() {
        return this.modifiers.contains((Object)Modifier.TEST);
    }

    public boolean isPreviewRealm() {
        return this.modifiers.contains((Object)Modifier.PREVIEW);
    }

    public List<Path> sourcePaths() {
        return this.sourcePaths;
    }

    public List<Path> modulePaths() {
        return this.modulePaths;
    }

    public String moduleSourcePath() {
        return Paths.join(this.sourcePaths).replace("{MODULE}", "*");
    }

    public Map<String, List<String>> argumentsFor() {
        return this.argumentsFor;
    }

    public List<String> argumentsFor(String string) {
        return this.argumentsFor.getOrDefault(string, List.of());
    }

    public String toString() {
        return String.format("Realm{name=%s, modifiers=%s}", this.name, this.modifiers);
    }

    public static enum Modifier {
        MAIN,
        TEST,
        PREVIEW;

    }
}

