/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Structure;
import de.sormuras.bach.project.Unit;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Project {
    private final String name;
    private final String group;
    private final ModuleDescriptor.Version version;
    private final Structure structure;

    public Project(String string, String string2, ModuleDescriptor.Version version, Structure structure) {
        this.name = string;
        this.group = string2;
        this.version = version;
        this.structure = structure;
    }

    public String name() {
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public ModuleDescriptor.Version version() {
        return this.version;
    }

    public Structure structure() {
        return this.structure;
    }

    public Folder folder() {
        return this.structure.folder();
    }

    public Optional<Unit> unit(String string, String string2) {
        for (Realm realm : this.structure.realms()) {
            if (!realm.name().equals(string)) continue;
            for (Unit unit : this.structure.units()) {
                if (!unit.name().equals(string2)) continue;
                return Optional.of(unit);
            }
        }
        return Optional.empty();
    }

    public List<Unit> units(Realm realm) {
        return this.structure().units().stream().filter(unit -> unit.realm() == realm).collect(Collectors.toList());
    }

    public Path modularJar(Unit unit) {
        String string = unit.name() + "-" + this.version(unit) + ".jar";
        return this.folder().modules(unit.realm().name(), string);
    }

    public Path sourcesJar(Unit unit) {
        String string = unit.name() + "-" + this.version(unit) + "-sources.jar";
        return this.folder().deploy(unit, string);
    }

    public Path javadocJar(Realm realm) {
        String string = this.name + "-" + this.version + "-javadoc.jar";
        return this.folder().deploy(realm.name(), string);
    }

    public ModuleDescriptor.Version version(Unit unit) {
        return unit.descriptor().version().orElse(this.version);
    }
}

