/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import de.sormuras.bach.project.Template;
import java.lang.module.ModuleDescriptor;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class Library {
    private final Set<Modifier> modifiers;
    private final Map<String, Link> links;
    private final Collection<Requires> requires;

    public static Library of() {
        return new Library(EnumSet.allOf(Modifier.class), Library.defaultLinks(), Set.of());
    }

    public static Map<String, Link> defaultLinks() {
        return new DefaultLinks();
    }

    public static void addJUnitTestEngines(Map<String, Set<ModuleDescriptor.Version>> map) {
        if (map.containsKey("org.junit.jupiter") || map.containsKey("org.junit.jupiter.api")) {
            map.putIfAbsent("org.junit.jupiter.engine", Set.of());
        }
        if (map.containsKey("junit")) {
            map.putIfAbsent("org.junit.vintage.engine", Set.of());
        }
    }

    public static void addJUnitPlatformConsole(Map<String, Set<ModuleDescriptor.Version>> map) {
        if (map.containsKey("org.junit.jupiter.engine") || map.containsKey("org.junit.vintage")) {
            map.putIfAbsent("org.junit.platform.console", Set.of());
        }
    }

    public Library(Set<Modifier> set, Map<String, Link> map, Collection<Requires> collection) {
        this.modifiers = set.isEmpty() ? Set.of() : EnumSet.copyOf(set);
        this.links = Map.copyOf(map);
        this.requires = collection;
    }

    public Set<Modifier> modifiers() {
        return this.modifiers;
    }

    public Map<String, Link> links() {
        return this.links;
    }

    public Collection<Requires> requires() {
        return this.requires;
    }

    public String toString() {
        return "Library{" + this.modifiers + ", links=" + this.links + ", requires=" + this.requires + "}";
    }

    public static enum Modifier {
        RESOLVE_RECURSIVELY,
        ADD_MISSING_JUNIT_TEST_ENGINES,
        ADD_MISSING_JUNIT_PLATFORM_CONSOLE;

    }

    private static class DefaultLinks
    extends TreeMap<String, Link> {
        private DefaultLinks() {
            this.put("org.apiguardian.api", Link.central("org.apiguardian", "apiguardian-api", "1.1.0"));
            this.put("org.opentest4j", Link.central("org.opentest4j", "opentest4j", "1.2.0"));
            this.putJUnitPlatform("1.6.0-RC1", "commons", "console", "engine", "launcher", "reporting");
            this.putJUnitJupiter("5.6.0-RC1", "", "api", "engine", "params");
            this.put("org.junit.vintage.engine", Link.central("org.junit.vintage", "junit-vintage-engine", "5.6.0-RC1"));
            this.put("junit", Link.central("junit", "junit", "4.13"));
            this.put("org.hamcrest", Link.central("org.hamcrest", "hamcrest", "2.2"));
            this.putJavaFX("13.0.1", "base", "controls", "fxml", "graphics", "media", "swing", "web");
            this.putJLWGL("3.2.3", "", "assimp", "bgfx", "cuda", "egl", "glfw", "jawt", "jemalloc", "libdivide", "llvm", "lmdb", "lz4", "meow", "nanovg", "nfd", "nuklear", "odbc", "openal", "opencl", "opengl", "opengles", "openvr", "opus", "ovr", "par", "remotery", "rpmalloc", "shaderc", "sse", "stb", "tinyexr", "tinyfd", "tootle", "vma", "vulkan", "xxhash", "yoga", "zstd");
        }

        private void putJavaFX(String string, String ... stringArray) {
            for (String string2 : stringArray) {
                String string3 = Template.Placeholder.JAVAFX_PLATFORM.getTarget();
                Link link = Link.central("org.openjfx", "javafx-" + string2, string, string3);
                this.put("javafx." + string2, link);
            }
        }

        private void putJLWGL(String string, String ... stringArray) {
            for (String string2 : stringArray) {
                String string3 = "lwjgl" + (String)(string2.isEmpty() ? "" : "-" + string2);
                String string4 = Template.Placeholder.LWJGL_NATIVES.getTarget();
                String string5 = "org.lwjgl" + (String)(string2.isEmpty() ? "" : "." + string2);
                this.put(string5, Link.central("org.lwjgl", string3, string));
                this.put(string5 + ".natives", Link.central("org.lwjgl", string3, string, string4));
            }
        }

        private void putJUnitJupiter(String string, String ... stringArray) {
            for (String string2 : stringArray) {
                String string3 = "junit-jupiter" + (String)(string2.isEmpty() ? "" : "-" + string2);
                Link link = Link.central("org.junit.jupiter", string3, string);
                String string4 = "org.junit.jupiter" + (String)(string2.isEmpty() ? "" : "." + string2);
                this.put(string4, link);
            }
        }

        private void putJUnitPlatform(String string, String ... stringArray) {
            for (String string2 : stringArray) {
                Link link = Link.central("org.junit.platform", "junit-platform-" + string2, string);
                this.put("org.junit.platform." + string2, link);
            }
        }
    }

    public static class Requires {
        private final String name;
        private final ModuleDescriptor.Version version;

        public static Requires of(String string) {
            int n = string.indexOf(64);
            if (n < 0) {
                return new Requires(string, null);
            }
            String string2 = string.substring(0, n);
            ModuleDescriptor.Version version = n > 0 ? ModuleDescriptor.Version.parse(string.substring(n + 1)) : null;
            return new Requires(string2, version);
        }

        public Requires(String string, ModuleDescriptor.Version version) {
            this.name = Objects.requireNonNull(string);
            this.version = version;
        }

        public String name() {
            return this.name;
        }

        public ModuleDescriptor.Version version() {
            return this.version;
        }
    }

    public static class Link {
        private final String reference;
        private final ModuleDescriptor.Version version;

        public static Link central(String string, String string2, String string3) {
            return Link.central(string, string2, string3, "");
        }

        public static Link central(String string, String string2, String string3, String string4) {
            return Link.of("https://repo1.maven.org/maven2", string, string2, string3, string4);
        }

        public static Link of(String string, String string2, String string3, String string4, String string5) {
            String string6 = Template.Placeholder.VERSION.getTarget();
            String string7 = string5.isBlank() ? string6 : string6 + "-" + string5;
            String string8 = "jar";
            String string9 = string3 + "-" + string7 + "." + string8;
            String string10 = String.join((CharSequence)"/", string, string2.replace('.', '/'), string3, string6, string9);
            return new Link(string10, ModuleDescriptor.Version.parse(string4));
        }

        public Link(String string, ModuleDescriptor.Version version) {
            this.reference = string;
            this.version = version;
        }

        public String reference() {
            return this.reference;
        }

        public ModuleDescriptor.Version version() {
            return this.version;
        }

        public String toString() {
            return "Link{" + this.reference + "@" + this.version + "}";
        }
    }
}

