/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Log;
import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Library;
import de.sormuras.bach.util.Paths;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import java.util.function.Function;

public class Configuration {
    private final Folder folder;
    private Log log;
    private String name;
    private String group;
    private ModuleDescriptor.Version version;
    private Library library;
    private int mainRelease;
    private int testRelease;
    private boolean mainPreview;
    private boolean testPreview;

    public static Configuration of() {
        return new Configuration(Folder.of());
    }

    public static Configuration of(String string, String string2) {
        return Configuration.of(string, string, string2);
    }

    public static Configuration of(String string, String string2, String string3) {
        return Configuration.of().setName(string).setGroup(string2).setVersion(ModuleDescriptor.Version.parse(string3));
    }

    public Configuration(Folder folder) {
        this.folder = folder;
        this.setLog(Log.ofSystem());
        this.setName(Property.PROJECT_NAME.get(Paths.name(folder.base(), "project")));
        this.setGroup(Property.PROJECT_GROUP.get(this.getName()));
        this.setVersion(Property.PROJECT_VERSION.ifPresent(ModuleDescriptor.Version::parse).orElse(Bach.Default.PROJECT_VERSION));
        this.setLibrary(Library.of());
        this.setMainRelease(0);
        this.setMainPreview(false);
        this.setTestRelease(Runtime.version().feature());
        this.setTestPreview(true);
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Log getLog() {
        return this.log;
    }

    public Configuration setLog(Log log) {
        this.log = log;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Configuration setName(String string) {
        this.name = string;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public Configuration setGroup(String string) {
        this.group = string;
        return this;
    }

    public ModuleDescriptor.Version getVersion() {
        return this.version;
    }

    public Configuration setVersion(ModuleDescriptor.Version version) {
        this.version = version;
        return this;
    }

    public Library getLibrary() {
        return this.library;
    }

    public Configuration setLibrary(Library library) {
        this.library = library;
        return this;
    }

    public int getMainRelease() {
        return this.mainRelease;
    }

    public Configuration setMainRelease(int n) {
        this.mainRelease = n;
        return this;
    }

    public int getTestRelease() {
        return this.testRelease;
    }

    public Configuration setTestRelease(int n) {
        this.testRelease = n;
        return this;
    }

    public boolean isMainPreview() {
        return this.mainPreview;
    }

    public Configuration setMainPreview(boolean bl) {
        this.mainPreview = bl;
        return this;
    }

    public boolean isTestPreview() {
        return this.testPreview;
    }

    public Configuration setTestPreview(boolean bl) {
        this.testPreview = bl;
        return this;
    }

    static enum Property {
        PROJECT_NAME,
        PROJECT_GROUP,
        PROJECT_VERSION;

        private final String key = this.name().toLowerCase().replace('_', '.');

        String get() {
            return System.getProperty(this.key);
        }

        String get(String string) {
            return System.getProperty(this.key, string);
        }

        <V> Optional<V> ifPresent(Function<String, V> function) {
            return Optional.ofNullable(this.get()).map(function);
        }
    }
}

