/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Task;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public class Log {
    private final Instant instant = Instant.now();
    private final Deque<Context> contexts = new ArrayDeque<Context>();
    private final List<Entry> entries = new ArrayList<Entry>();
    private final List<String> messages = new ArrayList<String>();
    private final List<Run> runs = new ArrayList<Run>();
    final PrintWriter out;
    final PrintWriter err;
    final boolean verbose;

    public static Log ofNullWriter() {
        Writer writer = PrintWriter.nullWriter();
        return new Log(new PrintWriter(writer), new PrintWriter(writer), false);
    }

    public static Log ofSystem() {
        boolean bl = Boolean.getBoolean("verbose");
        boolean bl2 = Boolean.getBoolean("ebug") || "".equals(System.getProperty("ebug"));
        return Log.ofSystem(bl || bl2);
    }

    public static Log ofSystem(boolean bl) {
        return new Log(new PrintWriter(System.out, true), new PrintWriter(System.err, true), bl);
    }

    protected Log(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.out = printWriter;
        this.err = printWriter2;
        this.verbose = bl;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    Context context(Task task) {
        return new Context(task);
    }

    private Entry message(System.Logger.Level level, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.messages.add(string2);
        Entry entry = new Entry(level, string2);
        this.entries.add(entry);
        return entry;
    }

    public Entry debug(String string, Object ... objectArray) {
        Entry entry = this.message(System.Logger.Level.DEBUG, string, objectArray);
        if (this.verbose) {
            this.out.println(entry.message);
        }
        return entry;
    }

    public Entry info(String string, Object ... objectArray) {
        Entry entry = this.message(System.Logger.Level.INFO, string, objectArray);
        this.out.println(entry.message);
        return entry;
    }

    public Entry warning(String string, Object ... objectArray) {
        Entry entry = this.message(System.Logger.Level.WARNING, string, objectArray);
        this.err.println(entry.message);
        return entry;
    }

    void tool(String string, String[] stringArray, Duration duration, int n) {
        String string2 = Optional.ofNullable(this.contexts.peek()).map(context -> context.task().getClass().getSimpleName()).orElse("<none>");
        this.runs.add(new Run(string2, string, stringArray, duration, n));
    }

    public class Context
    implements AutoCloseable {
        private final Task task;

        private Context(Task task) {
            this.task = task;
            Log.this.contexts.push(this);
        }

        public Task task() {
            return this.task;
        }

        @Override
        public void close() {
            Log.this.contexts.pop();
        }
    }

    public static class Entry {
        private final Instant instant = Instant.now();
        private final System.Logger.Level level;
        private final String message;

        private Entry(System.Logger.Level level, String string) {
            this.level = level;
            this.message = string;
        }

        public Instant instant() {
            return this.instant;
        }

        public System.Logger.Level level() {
            return this.level;
        }

        public String message() {
            return this.message;
        }

        public boolean isWarning() {
            return this.level == System.Logger.Level.WARNING;
        }
    }

    public static class Run {
        private final String task;
        private final String name;
        private final String[] args;
        private final Duration duration;
        private final int code;

        Run(String string, String string2, String[] stringArray, Duration duration, int n) {
            this.task = string;
            this.name = string2;
            this.args = stringArray;
            this.duration = duration;
            this.code = n;
        }

        public String task() {
            return this.task;
        }

        public String name() {
            return this.name;
        }

        public String[] args() {
            return this.args;
        }

        public Duration duration() {
            return this.duration;
        }

        public int code() {
            return this.code;
        }
    }
}

