/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.util.Paths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Call {
    private final boolean argumentFileSupport;
    private final String name;
    private final List<String> arguments;

    public Call(String string, String ... stringArray) {
        this(string, false, stringArray);
    }

    public Call(String string, boolean bl, String ... stringArray) {
        this.name = string;
        this.argumentFileSupport = bl;
        this.arguments = new ArrayList<String>();
        if (stringArray.length > 0) {
            Arrays.stream(stringArray).forEach(this::add);
        }
    }

    public Call(Call call) {
        this.argumentFileSupport = call.argumentFileSupport;
        this.name = call.name;
        this.arguments = new ArrayList<String>(call.arguments);
    }

    public String getName() {
        return this.name;
    }

    public Call add(Object object) {
        String string2 = object.toString();
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (this.argumentFileSupport && string2.charAt(0) == '@') {
            Path path = Path.of(string2.substring(1), new String[0]);
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new Error("Could not open: " + path);
            }
            Paths.readAllLines(path).stream().filter(Predicate.not(string -> string.startsWith("#"))).filter(Predicate.not(String::isEmpty)).forEach(this.arguments::add);
            return this;
        }
        this.arguments.add(string2);
        return this;
    }

    public Call add(String string, Object object) {
        return this.add(string).add(object);
    }

    public Call add(String string, List<Path> list) {
        if (list.isEmpty()) {
            return this;
        }
        return this.add(string).add(Paths.join(list));
    }

    public <T> Call forEach(Iterable<T> iterable, BiConsumer<Call, T> biConsumer) {
        iterable.forEach(object -> biConsumer.accept(this, object));
        return this;
    }

    public Call iff(boolean bl, Consumer<Call> consumer) {
        if (bl) {
            consumer.accept(this);
        }
        return this;
    }

    public Call iff(boolean bl, Consumer<Call> consumer, Consumer<Call> consumer2) {
        if (bl) {
            consumer.accept(this);
        } else {
            consumer2.accept(this);
        }
        return this;
    }

    public <T> Call iff(Optional<T> optional, BiConsumer<Call, T> biConsumer) {
        optional.ifPresent(object -> biConsumer.accept(this, object));
        return this;
    }

    public Call clone() {
        return new Call(this);
    }

    public String[] toArray(boolean bl) {
        return (String[])(bl ? this.toList(true) : this.arguments).toArray(String[]::new);
    }

    public List<String> toList(boolean bl) {
        if (!bl) {
            return List.copyOf(this.arguments);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1 + this.arguments.size());
        arrayList.add(this.name);
        arrayList.addAll(this.arguments);
        return List.copyOf(arrayList);
    }

    public String toString() {
        return "Call{name='" + this.name + "', arguments=" + this.arguments + "}";
    }
}

