/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Call;
import de.sormuras.bach.Log;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Configuration;
import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.ProjectBuilder;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.task.StartTask;
import de.sormuras.bach.util.Modules;
import de.sormuras.bach.util.Paths;
import de.sormuras.bach.util.Tools;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.spi.ToolProvider;

public class Bach {
    private final Log log;
    private final Project project;
    private final Tools tools;

    public static void main(String ... stringArray) {
        String string;
        if (stringArray.length == 0) {
            Bach.build(Bach.bach());
            return;
        }
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(List.of(stringArray));
        switch (string = arrayDeque.pop()) {
            case "build": {
                Bach.build(Bach.bach());
                return;
            }
            case "clean": {
                Paths.deleteIfExists(Default.OUT);
                return;
            }
            case "help": {
                System.out.println("F1 F1 F1");
                return;
            }
            case "start": {
                Bach.bach().execute(new StartTask(arrayDeque));
                return;
            }
            case "tool": {
                String string2 = arrayDeque.pop();
                int n = new Tools().launch(string2, arrayDeque);
                if (n != 0) {
                    throw new Error("Non-zero exit code! // args = " + List.of(stringArray));
                }
                return;
            }
        }
        throw new Error("Unsupported argument: " + string + " // args = " + List.of(stringArray));
    }

    private static Bach bach() {
        return Bach.bach(new Configuration(Folder.of(Default.BASE)));
    }

    public static Bach bach(Configuration configuration) {
        Log log = configuration.getLog();
        Project project = new ProjectBuilder(log).auto(configuration);
        return new Bach(log, project);
    }

    public static Bach build(Bach bach) {
        return bach.execute(Task.build());
    }

    public static Bach build(Configuration configuration) {
        return Bach.build(Bach.bach(configuration));
    }

    public static Bach build(String string, String string2) {
        return Bach.build(Bach.bach(Configuration.of(string, string2)));
    }

    public Bach(Log log, Project project) {
        this.log = Objects.requireNonNull(log);
        this.project = Objects.requireNonNull(project);
        this.tools = new Tools();
        log.debug("Bach.java (%s) initialized.", Modules.origin(this));
        this.logRuntimeAndProjectInformation();
    }

    private void logRuntimeAndProjectInformation() {
        this.log.debug("Runtime information", new Object[0]);
        this.log.debug("  - java.version = " + System.getProperty("java.version"), new Object[0]);
        this.log.debug("  - user.dir = " + System.getProperty("user.dir"), new Object[0]);
        this.log.debug("Tools of the trade", new Object[0]);
        this.tools.forEach(toolProvider -> this.log.debug("  - %8s [%s] %s", toolProvider.name(), Modules.origin(toolProvider), toolProvider));
        this.log.info("Project %s %s", this.project.name(), this.project.version());
        try {
            for (Field field : this.project.getClass().getFields()) {
                this.log.debug("  %s = %s", field.getName(), field.get(this.project));
            }
            for (Realm realm : this.project.structure().realms()) {
                this.log.debug("+ Realm %s", realm.name());
                for (Method method : realm.getClass().getDeclaredMethods()) {
                    if (method.getParameterCount() != 0) continue;
                    this.log.debug("  %s.%s() = %s", realm.name(), method.getName(), method.invoke((Object)realm, new Object[0]));
                }
                for (Unit unit : this.project.structure().units()) {
                    this.log.debug("- Unit %s", unit.name());
                    for (Method method : unit.getClass().getDeclaredMethods()) {
                        if (method.getParameterCount() != 0) continue;
                        this.log.debug("  (%s).%s() = %s", unit.name(), method.getName(), method.invoke((Object)unit, new Object[0]));
                    }
                }
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            this.log.warning(reflectiveOperationException.getMessage(), new Object[0]);
        }
    }

    public Log getLog() {
        return this.log;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isVerbose() {
        return this.log.verbose;
    }

    public Bach execute(Task ... taskArray) {
        try {
            for (Task task : taskArray) {
                String string = task.getClass().getSimpleName();
                try (Log.Context context = this.log.context(task);){
                    Log.Entry entry = this.log.debug("Executing task: %s", string);
                    context.task().execute(this);
                    long l = Duration.between(entry.instant(), Instant.now()).toMillis();
                    this.log.debug("%s took %d millis.", string, l);
                }
            }
        }
        catch (Exception exception) {
            throw new Error("Task failed to execute: " + exception, exception);
        }
        return this;
    }

    public Bach execute(String string, Object ... objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return this.execute(new Call(string, stringArray));
    }

    public Bach execute(Call ... callArray) {
        for (Call call : callArray) {
            int n = this.run(call);
            if (n == 0) continue;
            throw new Error("Call exited with non-zero exit code: " + n + " <- " + call);
        }
        return this;
    }

    public int run(Call call) {
        return this.run(this.tools.get(call.getName()), call);
    }

    public int run(ToolProvider toolProvider, Call call) {
        String string = toolProvider.name();
        CharSequence[] charSequenceArray = call.toArray(false);
        Log.Entry entry = this.log.debug("Running tool: %s %s", string, String.join((CharSequence)" ", charSequenceArray));
        int n = toolProvider.run(this.log.out, this.log.err, (String[])charSequenceArray);
        this.log.tool(string, (String[])charSequenceArray, Duration.between(entry.instant(), Instant.now()), n);
        return n;
    }

    public int start(List<String> list) throws IOException, InterruptedException {
        String string = list.get(0);
        String[] stringArray = (String[])list.subList(1, list.size()).toArray(String[]::new);
        Log.Entry entry = this.log.debug("Starting command: %s", String.join((CharSequence)" ", list));
        int n = new ProcessBuilder(list).inheritIO().start().waitFor();
        this.log.tool(string, stringArray, Duration.between(entry.instant(), Instant.now()), n);
        return n;
    }

    public static interface Default {
        public static final Path BASE = Path.of("", new String[0]);
        public static final Path SRC = Path.of("src", new String[0]);
        public static final Path LIB = Path.of("lib", new String[0]);
        public static final Path OUT = Path.of(".bach/out", new String[0]);
        public static final String PROJECT_NAME = "project";
        public static final ModuleDescriptor.Version PROJECT_VERSION = ModuleDescriptor.Version.parse("0");
        public static final String MAVEN_POM_TEMPLATE = "maven-pom-template.xml";
        public static final String MAVEN_CLI_ARGUMENTS = "maven-cli-arguments.txt";
    }
}

