/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.util;

import java.io.BufferedReader;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Paths {
    public static final Path USER_HOME = Path.of(System.getProperty("user.home"), new String[0]);

    private Paths() {
    }

    public static Path createDirectories(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Create directories failed: " + path, exception);
        }
        return path;
    }

    public static List<Path> filter(List<Path> list, Predicate<Path> predicate) {
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static List<Path> filterExisting(List<Path> list) {
        return Paths.filter(list, path -> Files.exists(path, new LinkOption[0]));
    }

    public static List<Path> find(Collection<Path> collection, Predicate<Path> predicate) {
        TreeSet treeSet = new TreeSet();
        for (Path path : collection) {
            try {
                Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
                try {
                    stream.filter(predicate).forEach(treeSet::add);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {
                throw new Error("Walking directory '" + path + "' failed: " + exception, exception);
            }
        }
        return List.copyOf(treeSet);
    }

    public static boolean isJavaFile(Path path) {
        String string;
        if (Files.isRegularFile(path, new LinkOption[0]) && (string = path.getFileName().toString()).endsWith(".java")) {
            return string.indexOf(46) == string.length() - 5;
        }
        return false;
    }

    public static boolean isModuleFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().equals("module-info.java");
    }

    public static boolean isJarFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar");
    }

    public static String join(List<Path> list) {
        return list.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }

    public static Properties load(Properties properties, Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                properties.load(bufferedReader);
            }
            catch (Exception exception) {
                throw new RuntimeException("Load properties failed: " + path, exception);
            }
        }
        return properties;
    }

    public static List<Path> list(Path path, Predicate<Path> predicate) {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.list(path);
            try {
                list = stream.filter(predicate).sorted().collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException("List directory failed: " + path, exception);
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> list(Path path, String string) {
        List<Path> list;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, string);
            try {
                list = StreamSupport.stream(directoryStream.spliterator(), false).sorted().collect(Collectors.toList());
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException("List directory using glob failed: " + path, exception);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    public static String readString(Path path) {
        try {
            return Files.readString(path);
        }
        catch (Exception exception) {
            throw new RuntimeException("Read all content from file failed: " + path, exception);
        }
    }

    public static String star(Path path, String string) {
        return Paths.toString(path, string, true, "*");
    }

    public static String toString(Path path, String string, boolean bl, String ... stringArray) {
        Path path2;
        String string2;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(List.of(stringArray));
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Path> iterator = path.iterator();
        while (iterator.hasNext() && !(string2 = (path2 = iterator.next()).toString()).equals("module-info.java")) {
            if (!arrayDeque.isEmpty() && string2.equals(string)) {
                arrayList.add(bl ? arrayDeque.pop() : arrayDeque.peek());
                continue;
            }
            arrayList.add(string2);
        }
        return String.join((CharSequence)File.separator, arrayList);
    }
}

