/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.util;

import de.sormuras.bach.Log;
import de.sormuras.bach.project.Deployment;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.util.Modules;
import de.sormuras.bach.util.Uris;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;

public class Maven {
    private final Log log;
    private final Uris uris;
    private final Lookup groupArtifacts;
    private final Lookup versions;

    public Maven(Log log, Uris uris, Lookup lookup, Lookup lookup2) {
        this.log = log;
        this.uris = uris;
        this.groupArtifacts = lookup;
        this.versions = lookup2;
    }

    public String lookup(String string) {
        return this.lookup(string, this.versions.apply(string));
    }

    public String lookup(String string, String string2) {
        return this.groupArtifacts.apply(string) + ":" + string2;
    }

    public String version(String string) {
        return this.versions.apply(string);
    }

    public URI toUri(String string, String string2, String string3, String string4) {
        return this.toUri(string, string2, string3, string4, "", "jar");
    }

    public URI toUri(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7;
        String string8 = string5.isBlank() ? string4 : string4 + "-" + string5;
        Object object = string3 + "-" + string8 + "." + string6;
        if (string4.endsWith("SNAPSHOT")) {
            string7 = String.join((CharSequence)"/", string, string2.replace('.', '/'), string3, string4);
            URI uRI = URI.create(string7 + "/maven-metadata.xml");
            try {
                String string9 = this.uris.read(uRI);
                String string10 = Maven.substring(string9, "<timestamp>", "<");
                String string11 = Maven.substring(string9, "<buildNumber>", "<");
                String string12 = string10 + "-" + string11;
                this.log.debug("%s:%s:%s -> %s", string2, string3, string4, string12);
                object = ((String)object).replace("SNAPSHOT", string12);
            }
            catch (Exception exception) {
                this.log.warning("Maven metadata extraction from %s failed: %s", uRI, exception);
            }
        }
        string7 = String.join((CharSequence)"/", new CharSequence[]{string, string2.replace('.', '/'), string3, string4, object});
        return URI.create(string7);
    }

    static String substring(String string, String string2, String string3) {
        int n = string.indexOf(string2) + string2.length();
        int n2 = string.indexOf(string3, n);
        return string.substring(n, n2).trim();
    }

    public static class Scribe {
        final Project project;

        public Scribe(Project project) {
            this.project = project;
        }

        public void generateMavenInstallScript(Iterable<Unit> iterable) {
            for (ScriptType scriptType : ScriptType.values()) {
                this.generateMavenInstallScript(scriptType, iterable);
            }
        }

        void generateMavenInstallScript(ScriptType scriptType, Iterable<Unit> iterable) {
            String string = "install:install-file";
            String string2 = String.join((CharSequence)" ", "mvn", "--batch-mode", "--no-transfer-progress", string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Unit unit : iterable) {
                if (!unit.mavenPom().isPresent()) continue;
                arrayList.add(String.join((CharSequence)" ", string2, this.generateMavenArtifactLine(unit, scriptType)));
            }
            if (arrayList.isEmpty()) {
                return;
            }
            try {
                Path path = this.project.folder().out("maven-install" + scriptType.extension);
                Files.write(path, scriptType.lines(arrayList), new OpenOption[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException("Generating install script failed: " + exception.getMessage(), exception);
            }
        }

        public void generateMavenDeployScript(Iterable<Unit> iterable) {
            Optional<Deployment> optional = this.project.deployment();
            if (optional.isEmpty()) {
                return;
            }
            for (ScriptType scriptType : ScriptType.values()) {
                this.generateMavenDeployScript(scriptType, optional.get(), iterable);
            }
        }

        void generateMavenDeployScript(ScriptType scriptType, Deployment deployment, Iterable<Unit> iterable) {
            String string = "org.apache.maven.plugins:maven-deploy-plugin:3.0.0-M1:deploy-file";
            String string2 = "repositoryId=" + scriptType.quote(deployment.mavenRepositoryId());
            String string3 = "url=" + scriptType.quote(deployment.mavenUri());
            String string4 = String.join((CharSequence)" ", "mvn", "--batch-mode", string);
            String string5 = String.join((CharSequence)" ", "-D" + string2, "-D" + string3);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Unit object : iterable) {
                arrayList.add(String.join((CharSequence)" ", string4, string5, this.generateMavenArtifactLine(object, scriptType)));
            }
            if (arrayList.isEmpty()) {
                return;
            }
            try {
                String string6 = "maven-deploy-" + deployment.mavenRepositoryId();
                Path path = this.project.folder().out((String)string6 + scriptType.extension);
                Files.write(path, scriptType.lines(arrayList), new OpenOption[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException("Deploy failed: " + exception.getMessage(), exception);
            }
        }

        String generateMavenArtifactLine(Unit unit, ScriptType scriptType) {
            String string = "pomFile=" + scriptType.quote(unit.mavenPom().orElseThrow());
            String string2 = "file=" + scriptType.quote(this.project.modularJar(unit));
            String string3 = "sources=" + scriptType.quote(this.project.sourcesJar(unit));
            String string4 = "javadoc=" + scriptType.quote(this.project.javadocJar(unit.realm()));
            return String.join((CharSequence)" ", "-D" + string, "-D" + string2, "-D" + string3, "-D" + string4);
        }

        static enum ScriptType {
            BASH(".sh", '\''),
            WIN(".bat", '\"'){

                @Override
                List<String> lines(List<String> list) {
                    return list.stream().map(string -> "call " + string).collect(Collectors.toList());
                }
            };

            final String extension;
            final char quote;

            private ScriptType(String string2, char c) {
                this.extension = string2;
                this.quote = c;
            }

            String quote(Object object) {
                return this.quote + object.toString() + this.quote;
            }

            List<String> lines(List<String> list) {
                return list;
            }
        }
    }

    public static class Lookup
    implements UnaryOperator<String> {
        final UnaryOperator<String> custom;
        final Map<String, String> library;
        final Set<Pattern> libraryPatterns;
        final Map<String, String> fallback;

        public Lookup(UnaryOperator<String> unaryOperator, Map<String, String> map, Map<String, String> map2) {
            this.custom = unaryOperator;
            this.library = map;
            this.fallback = map2;
            this.libraryPatterns = map.keySet().stream().map(Object::toString).filter(string -> !SourceVersion.isName(string)).map(Pattern::compile).collect(Collectors.toSet());
        }

        @Override
        public String apply(String string) {
            Object object;
            String string2;
            try {
                string2 = (String)this.custom.apply(string);
                if (string2 != null) {
                    return string2;
                }
            }
            catch (Modules.UnmappedModuleException unmappedModuleException) {
                // empty catch block
            }
            string2 = this.library.get(string);
            if (string2 != null) {
                return string2;
            }
            if (this.libraryPatterns.size() > 0) {
                object = this.libraryPatterns.iterator();
                while (object.hasNext()) {
                    Pattern pattern = (Pattern)object.next();
                    if (!pattern.matcher(string).matches()) continue;
                    return this.library.get(pattern.pattern());
                }
            }
            if ((object = this.fallback.get(string)) != null) {
                return object;
            }
            throw new Modules.UnmappedModuleException(string);
        }
    }
}

