/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Log;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.task.Tester;
import java.util.List;

public class TestTask
implements Task {
    @Override
    public void execute(Bach bach) throws Exception {
        Log log = bach.getLog();
        Project project = bach.getProject();
        for (Realm realm : project.structure().realms()) {
            List<Unit> list;
            if (!realm.isTestRealm() || (list = project.units(realm)).isEmpty()) continue;
            log.debug("Testing %d %s unit(s): %s", list.size(), realm.name(), list);
            new Tester(bach, realm).test(list);
        }
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            System.gc();
            Thread.sleep(256L);
        }
    }
}

